(function () {

    $(document).ready(function() {
        $('.js-example-basic-multiple:visible').select2();
    });

    function initialize() {
        removerFactoryUser();
        insertFactoryUser();
        onInsertRegion();
        onInsertUser();
        onRemoveUser();
        onRegisterUser();
        onRegisterRegion();
        onRemoveRegion();
        onInsertAgent();
        onRegisterAgent();
        onIdentityShow();
        onInvestorShow();
   }


    function onRemoveUser() {

        $('body').on( 'click','.delete-user', function() {
            let btnDelUser=$(this);
            let userFactoryId=btnDelUser.attr('id');
            const httpService = new HttpService({
                route: 'gas_liquid/factory-user/delete-user-ajax',
                method: 'post',
                data: {'userFactoryId':userFactoryId},
                success: function (result) {
                    var response = JSON.parse(result);
                    swal.fire(response.msg);
                    $("#messageBoxUser").html(response.msg);
                    if (response.result==1) {
                        btnDelUser.closest('div.row').remove();
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function removerFactoryUser() {

        $('body').on( 'click','.removeContent', function() {
            $(this).parent('div').closest('div.parent_of_dropdown').remove();
        });
    }
    function insertFactoryUser(){

        $(document).on('click', '#insert_user', function (e) {
            const $btn=$(this);
            let $userDropDown = $btn.closest('div.parent_of_dropdown').find('select.users_list');
            console.log($userDropDown);
            const httpService = new HttpService({
                route: 'gas_liquid/factory/insert_user_block',
                method: 'get',
                data: {factory:$btn.attr('data-content'),id:$userDropDown.attr('id')},
                success: function (data) {
                    if (data == "0") {
                        swal.fire("Error");
                    } else {
                        $("#description-block").before(data);
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onRegisterUser(){

        $(document).on('click', '.register-user', function (e) {

            let dataForm = jQuery("#userForm").serializeArray();
            let factoryId=$('#user_factory_id').val();
            const httpService = new HttpService({
                route: 'gas_liquid/factory-user/create-user-ajax',
                method: 'post',
                data: {'data':dataForm,'factoryId':factoryId},
                success: function (result) {
                    var response = JSON.parse(result);
                    swal.fire(response.msg);
                    $("#messageBoxUser").html(response.msg);
                    if(response.result==1) {
                        $('.users_list:last').append(response.data);
                        $('#UserModal').modal('hide');
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onInsertUser() {
        $(document).on('click', '.btn-insert-user', function (e) {
            document.getElementById("userForm").reset();
            $("#messageBoxUser").html('');
            $('#UserModal').modal('show');
        });
    }

    function onInsertAgent() {
        $(document).on('click', '.btn-insert-agent', function (e) {
            document.getElementById("agentForm").reset();
            $("#messageBoxAgent").html('');
            $('#AgentModal').modal('show');
        });
    }
    function onRegisterAgent(){

        $(document).on('click', '.register-agent', function (e) {

            let dataForm = jQuery("#agentForm").serializeArray();
            const httpService = new HttpService({
                route: 'gas_liquid/agent/create-ajax',
                method: 'post',
                data: {'data':dataForm},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.msg);
                        $("#messageBoxAgent").html(response.msg);
                        $('#factoryagentslogic-agent_id').append(response.data);
                        $('#AgentModal').modal('hide');
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }

    function onRegisterRegion(){

        $(document).on('click', '#register-region', function (e) {

            let region = $('#factoryregionslogic-region').val();
            let factory=$('#user_factory_id').val();
            const httpService = new HttpService({
                route: 'gas_liquid/factory-regions/create-region-ajax',
                method: 'post',
                data: {'region':region,'factory':factory},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.message);
                        $("#messageBoxRegion").html(response.message);
                        if(response.result==1) {
                            $('#factoryagentslogic-region_id').append(response.data);
                            $('#RegionModal').modal('hide');
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onRemoveRegion(){

        $(document).on('click', '.remove-region', function (e) {
            let btnDel=$(this);
            let id = btnDel.attr('id');
            const httpService = new HttpService({
                route: 'gas_liquid/factory-regions/delete-region-ajax',
                method: 'post',
                data: {'id':id},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.message);
                        $("#messageBox").html(response.message);
                        if(response.result==1) {
                            btnDel.closest('tr').remove();
                            $('#RegionModal').modal('hide');
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onInsertRegion() {
        $(document).on('click', '.btn-insert-region', function (e) {
            $('#factoryregionslogic-region').val('');
            $("#messageBoxRegion").html('');
            $('#RegionModal').modal('show');
        });
    }
    function onIdentityShow(){

        $(document).on('click', '.edit-identity', function (e) {
            let btnEdit=$(this);
            let id = btnEdit.attr('data');
            const httpService = new HttpService({
                route: 'gas_liquid/factory-investors/fetch-identity-ajax',
                method: 'post',
                data: {'id':id},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        if(response.result==1) {
                            $('#identityModalLabel').html(response.title)
                            if(response.id) {
                                $(".identity-form").append(response.id);
                            }
                            if(response.identity) {
                                $.each(response.identity, function (field, value) {
                                    $(".identity-form input[name='IdentityLogic[" + field + "]']").val(value);
                                    $(".identity-form input[name='IdentityLogic[" + field + "]']").attr('value', value);
                                });
                            }
                            $('#IdentityModal').modal('show');
                        }else{
                            $("#messageBox").html(response.message);
                            swal.fire(response.message);
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }

    function onInvestorShow(){

        $(document).on('click', '.edit-investor', function (e) {
            let btnEdit=$(this);
            let id = btnEdit.attr('data');
            const httpService = new HttpService({
                route: 'gas_liquid/factory-investors/fetch-investor-ajax',
                method: 'post',
                data: {'id':id},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        if(response.result==1) {
                            if(response.id) {
                                $(".investor-form").append(response.id);
                            }
                            $('#investorModalLabel').html(response.title)
                            $.each(response.investor, function(field, value){
                                $(".investor-form input[name='FactoryInvestorsLogic["+field+"]']").val(value);
                            });
                            $('#InvestorModal').modal('show');
                        }else{
                            $("#messageBox").html(response.message);
                            swal.fire(response.message);
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    initialize();

})();

