(function () {

    $(document).ready(function() {
        $('.js-example-basic-multiple:visible').select2();

    });

    function initialize() {
        onPrint();
        onShowDailyReportForm();
        onRegisterDailyReport();
    }


    function  onPrint() {

        $(document).on('click', '.btn-print', function (e) {
            var body = document.body;
            body.classList.add("A4");
            e.preventDefault();
            var printContents = document.getElementById('print-info').innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
           //$('.print-wrapper').dialog.printElement();
           location.reload();
        });
    }

    function onRegisterDailyReport(){

        $(document).on('click', '.register-daily-report', function (e) {

            let dataForm = jQuery("#dailyReportForm").serializeArray();
            const httpService = new HttpService({
                route: '../create-daily-report-ajax',
                method: 'post',
                data: {'data':dataForm},
                success: function (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.msg);
                        var customer=response.data.customer_id;
                        if(response.result==1) {
                            $('.info-gasliquid-table-list').find('tr[data-content=' + customer + ']').removeClass('public-not-entry');
                            $('.info-gasliquid-table-list').find('tr[data-content=' + customer + ']').addClass('public-entry');
                            $('.info-gasliquid-table-list').find('tr[data-content=' + customer + ']').find('td.td-info-input').html(response.data.input);
                            $('.info-gasliquid-table-list').find('tr[data-content=' + customer + ']').find('td.td-info-stock').html(response.data.stock);
                            $('.info-gasliquid-table-list').find('tr[data-content=' + customer + ']').find('td.td-info-output').html(response.data.output);
                        }

                    $("#messageBoxDailyReport").html(response.msg);
                    $('#DailyReportModal').modal('hide');
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onShowDailyReportForm() {
        $(document).on('click', '.btn-show-daily-report', function (e) {
            var btnShowDailyReport=$(this);
            var customerId=btnShowDailyReport.closest('tr.tr-parent').attr('data-content');
            var info_date=$('#DailyReportModal').find('input#factorydailyreportlogic-info_date').attr('value');
            $('#DailyReportModal').find('input#factorydailyreportlogic-factory_id').val(customerId);
            const httpService = new HttpService({
                route: '../fetch-daily-report-ajax',
                method: 'post',
                data: {'customer':customerId,'date':info_date},
                success: function (result) {
                        var response = JSON.parse(result);
                    $('#DailyReportModal').find('#dailyReportModalLabel').html(response.data.title);
                    $('#DailyReportModal').find('input#factorydailyreportlogic-customer_id').val(response.data.customer_id);
                    if(response.result==1){
                            $('#DailyReportModal').find('input#factorydailyreportlogic-stock').val(response.data.stock);
                            $('#DailyReportModal').find('input#factorydailyreportlogic-input').val(response.data.input);
                            $('#DailyReportModal').find('input#factorydailyreportlogic-output').val(response.data.output);
                            $('#DailyReportModal').find('input#factorydailyreportlogic-id').val(response.data.id);
                        }
                        $("#messageBoxDailyReport").html('');
                        $('#DailyReportModal').modal('show');
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();
        });
    }


    initialize();

})();

