(function () {

    $(document).ready(function() {
        $('.js-example-basic-multiple:visible').select2();
    });

    function initialize() {
        onShowMessageForm();
        onSendMessage();
        onChangeMessageType();
    }
    function onShowMessageForm() {

        $(document).on('click','.whatsapp-btn',function (e) {
            var agentId=$(this).attr('data-id');
            $('#messageform-agent').val(agentId);
            const httpService = new HttpService({
                route: 'gas_liquid/ajax/show-message-form',
                method: 'get',
                data: {agentId:  agentId},
                success: function (response) {
                    $('#messageform-user').html(response.data.user);
                    $('#exampleModalLabel').html(response.data.agent);
                    $('#messageform-message').html(response.data.message);
                    $('#messageform-phone').val(response.data.phone);
                    $("#messageModal").modal('show');
                    //location.reload();
                },
                error: function (response) {
                    swal.fire('server error');
                }
            });
            httpService.send();
        })

    }
    function onChangeMessageType() {

        $(document).on('change','#messageform-message_type',function (e) {
            var userId=$('#messageform-user').val();
            var agentId=$('#messageform-agent').val();
            var messageType=$(this).val();
            const httpService = new HttpService({
                route: 'gas_liquid/ajax/change-message',
                method: 'get',
                data: {userId:  userId,agentId:agentId,messageType:messageType},
                success: function (response) {
                    $('#messageform-message').html(response.data.message);
                },
                error: function (response) {
                    swal.fire('server error');
                }
            });
            httpService.send();
        })
    }
    function onChangeUser() {

        $(document).on('change','#messageform-user',function (e) {
            var userId=$(this).val();
            var messageType=$('#messageform-message_type').val();
            var agentId=$('#messageform-agent').val();
            const httpService = new HttpService({
                route: 'gas_liquid/ajax/change-user',
                method: 'get',
                data: {userId:  userId,agentId:agentId,messageType:messageType},
                success: function (response) {
                    $('#messageform-phone').val(response.data.phone);
                    if(response.data.message) $('#messageform-message').html(response.data.message);
                },
                error: function (response) {
                    swal.fire('server error');
                }
            });
            httpService.send();
        })
    }
    function onSendMessage() {
        $(document).on('click','.send-message',function (e) {
            var phone=$('#messageform-phone').val();
            var message=$('#messageform-message').html();
            if(phone && message) {
                phone='964'+phone;
                message=encodeURIComponent(message);
                //$("#messageModal").modal('hide');
                window.open("https://api.whatsapp.com/send/?phone=" + phone + "&text=" + message+"&type=phone_number", '_blank');
            }
            else
                swal.fire('phone and message are required!');
        })
    }

    initialize();

})();

