(function () {

    $(document).ready(function() {
        $('.js-example-basic-multiple:visible').select2();
    });

    function initialize() {
        changeType();
        //changeFactory();
        onInsertUser();
        onRemoveUser();
        removerAgentUser();
        insertAgentUser();
        onRegisterUser();
        onInsertRegion();
        onRegisterRegion();
        onRemoveRegion();

    }


    function changeFactory(){
        $(document).on('change', '#agentlogic-sale_customer_id', function (e) {
            let factoryDropDown=$(this);
            let factoryId=factoryDropDown.val();
            const httpService = new HttpService({
                route: 'gas_liquid/factory-regions/get-region-ajax',
                method: 'post',
                data: {'factoryId':factoryId},
                success: function (result) {
                    var response = JSON.parse(result);
                    $("#agentList").append(response.data);
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();
            });
    }
    function changeType(){
        $(document).on('change', '#agentlogic-type', function (e) {
            const $type=$(this).val();
                if($type==0){
                    $('.type-2').hide();
                    $('.type-1').show();
                }else if($type==1){
                    $('.type-1').hide();
                    $('.type-2').show();
                }
            });
    }
    function onInsertUser() {
        $(document).on('click', '.btn-insert-user', function (e) {
            document.getElementById("userForm").reset();
            $("#messageBoxUser").html('');
            $('#UserModal').modal('show');
        });
    }
    function onRemoveUser() {

        $('body').on( 'click','.delete-user', function() {
            let btnDelUser=$(this);
            let userAgentId=btnDelUser.attr('id');
            const httpService = new HttpService({
                route: 'gas_liquid/agent-user/delete-user-ajax',
                method: 'post',
                data: {'userAgentId':userAgentId},
                success: function (result) {
                    var response = JSON.parse(result);
                    swal.fire(response.msg);
                    $("#messageBoxUser").html(response.msg);
                    if (response.result==1) {
                        btnDelUser.closest('div.row').remove();
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function removerAgentUser() {

        $('body').on( 'click','.removeContent', function() {
            $(this).parent('div').closest('div.parent_of_dropdown').remove();
        });
    }
    function insertAgentUser(){

        $(document).on('click', '#insert_user', function (e) {
            const $btn=$(this);
            let $userDropDown = $btn.closest('div.parent_of_dropdown').find('select.users_list');
            console.log($userDropDown);
            const httpService = new HttpService({
                route: 'gas_liquid/agent-user/insert_user_block',
                method: 'get',
                data: {agent:$btn.attr('data-content'),id:$userDropDown.attr('id')},
                success: function (data) {
                    if (data == "0") {
                        swal.fire("Error");
                    } else {
                        $("#description-block").before(data);
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onRegisterUser(){

        $(document).on('click', '.register-user', function (e) {

            let dataForm = jQuery("#userForm").serializeArray();
            let agentId=$('#user_agent_id').val();
            const httpService = new HttpService({
                route: 'gas_liquid/agent-user/create-user-ajax',
                method: 'post',
                data: {'data':dataForm,'agentId':agentId},
                success: function (result) {
                    var response = JSON.parse(result);
                    swal.fire(response.msg);
                        $("#messageBoxUser").html(response.msg);
                        if(response.result==1) {
                            $('.product-form-group').append(response.data);
                            $('#UserModal').modal('hide');
                        }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onRegisterRegion(){

        $(document).on('click', '#register-region', function (e) {

            let region = $('#factoryregionslogic-region').val();
            const httpService = new HttpService({
                route: 'gas_liquid/factory-regions/create-region-ajax',
                method: 'post',
                data: {'region':region},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.message);
                        $("#messageBoxRegion").html(response.message);
                        if(response.result==1) {
                            $("select#agentlogic-sale_region option:selected").removeAttr('selected');
                            $("select#agentlogic-sale_region").append(response.data);
                            $('#RegionModal').modal('hide');
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onRemoveRegion(){

        $(document).on('click', '.remove-region', function (e) {
            let btnDel=$(this);
            let id = btnDel.attr('id');
            const httpService = new HttpService({
                route: 'gas_liquid/factory-regions/delete-region-ajax',
                method: 'post',
                data: {'id':id},
                success: function (result) {
                    if (result) {
                        var response = JSON.parse(result);
                        swal.fire(response.message);
                        $("#messageBox").html(response.message);
                        if(response.result==1) {
                            btnDel.closest('tr').remove();
                            $('#RegionModal').modal('hide');
                        }
                    }
                },
                error: function (data) {
                    $("#message").html('Server Error');
                }
            });
            httpService.send();

        });

    }
    function onInsertRegion() {
        $(document).on('click', '.btn-insert-region', function (e) {
            $('#factoryregionslogic-region').val('');
            $("#messageBoxRegion").html('');
            $('#RegionModal').modal('show');
        });
    }
    initialize();

})();

