<?php

/* @var $this \yii\web\View */

/* @var $content string */

use backend\assets\AppAsset;
use common\widgets\MainSideMenu;
use common\widgets\Icons;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\helpers\Url;
use yii\widgets\Breadcrumbs;
use common\widgets\Alert;

AppAsset::register($this);
\backend\modules\gas_liquid\assets\GasLiquidAsset::register($this)
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" style="">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php $this->registerCsrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
        <?= Icons::widget(); ?>

    </head>
    <body class="gasLiquid-layout">
    <?php $this->beginBody() ?>

    <div class="container-fluid gasLiquid" id="main-body-gasLiquid">
       <div class="gasLiquid-wrap">
            <header class=" gasLiquid-header">
                <div class="row ">
                    <div class=" header-logo-brand   col-sm-6 col-md-6 ">
                        <a href="#" target="_blank" class="brand-logo2" title="<?= Yii::$app->name; ?>" >
                            <?= Html::img('@web/images/logo-img2.png'); ?>
                        </a>
                        <div class="branding-text ">
                            <h1><?= Yii::t('app', 'نظام تسجيل وتوزيع المنتجات النفطية'); ?>
                                <br>  <?= Yii::t('app', 'توزيع معامل غاز'); ?>
                            </h1>
                        </div>
                    </div>
                    <div class=" header-user-info  col-sm-3 col-md-3 ">
                        <div id="user-info-box" class="">
                            <span class="icon-user"></span>
                            <span class="name-span-1">

                            <!--   <?/*= Yii::$app->user->identity->name; */?>       -->

                            الامين الاهلي
                            </span>
                            <br>
                            <span class="name-span-2">
                                   محمد جبار حسين جلاب
                              </span>
                        </div>
                    </div>

                    <div class="header-toolbar   col-sm-3 col-md-3 pr-md-1  ">
                        <div class="row header-toolbar-row">
                            <div class="top-clock col-8 col-md-8">
                                <div id="clockbox" class="clockbox">   </div>  <span class="icon-152 calander-icon"></span>
                            </div>
                            <div class="top-logout mr-auto  col-4 col-md-4">
                                <?= Html::a('<i class="icon-log-out"></i>'.Yii::t('app', 'Exit'), ['/site/logout'], ['class' => '   logout-link', 'data-method' => "post"]) ?>
                            </div>
                        </div>

                    </div>
                    <section class="container-fluid breadcrumb-container">
                        <div class="breadcrumb-row row">

                            <div class="Breadcrumbs-box">
                                <?= Breadcrumbs::widget([
                                    'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                                ]) ?>
                            </div>


                            <div class="back-button  ">
                                <?= \common\widgets\BackButton::widget() ?>
                            </div>

                        </div>
                    </section>
                </div>
            </header>
            <div class="container-fluid gasLiquid-content">
                <?= $content ?>
            </div>
            <div class="footer-wrap">
                <?/*= Html::img('@web/images/oil-logo.png'); */?>
                <!--a href="" target="_blank" title=""-->
                <?= Html::img('@web/images/ebda.png'); ?>
                <!--/a-->

            </div>

        </div>

    </div>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>