<?php

/* @var $this \yii\web\View */

/* @var $content string */

use backend\assets\AppAsset;
use backend\modules\transport\assets\TransportAsset;
use common\widgets\Icons;
use yii\helpers\Html;
use yii\widgets\Breadcrumbs;
use common\widgets\Alert;
use yii\helpers\Url;


TransportAsset::register($this);
AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <base href="<?= Url::base(true); ?>">
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <?= Icons::widget(); ?>

</head>
<body class="hold-transition  main-transport-body <?php if (Yii::$app->user->identity->role=='transport') echo 'transport-body';
if (Yii::$app->user->identity->role=='driver') echo 'driverPanel-body'; ?>" id=""><!--layout-fixed- for autoscrollbar-->
<?php $this->beginBody() ?>
<div class="container-fluid wrapper transport-page <?php if (Yii::$app->user->identity->role=='driver') echo 'driverPanel-wrapper '; ?>  ">

    <div class="">
        <div class="<?php if (Yii::$app->user->identity->role=='transport') echo 'transport-content-body';  if (Yii::$app->user->identity->role=='driver') echo 'driverPanel-contents'; ?>">
            <nav class="main-header navbar navbar-expand   left-panel ">
                <div class="header-left col-md-12  ">

                    <div class="container">
                        <div class="row w-100">
                            <div class="col-md-11 col-sm-10 col-10 htop-1">

                                <div class="top-green user-info">
                                    <div class="row m-0">
                                        <div id="user-info2"
                                             class=" col-lg-3 col-md-3 col-sm-3 col-4"><?= Yii::t('app', 'اسم المستخدم') ?>:
                                            <br> <span><?= Yii::$app->user->identity->name; ?></span>
                                        </div>

                                        <div class="site-title  col-lg-7 col-md-7  col-sm-7 col-8">
                                            <h2><?= Yii::t('app', 'نظام تسجيل وتوزيع') ?>
                                                <?= Yii::t('app', 'المنتجات النفطية') ?></h2>
                                        </div>

                                        <div class="mr-auto top-clock col-lg-2 col-md-2 col-sm-2 mobile-hidden">
                                            <div id="clockbox" class="clockbox"></div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1  col-sm-2 col-2 htop-2 ">
                                <div class="top-left-nav">
                                    <div class="row">
                                        <!-- <div class="col-md-6  col-6 ">
                                        <div class="top-green nav-dropdown">

                                            <a class="send-icon" href="#" data-toggle="dropdown"
                                               class=" send-icon">

                                                <i class="icon-Email1 icon-top-btn"></i> <span
                                                        class="badge badge-warning navbar-badge">15</span><br>

                                                <? /*= Yii::t('app', 'Send'); */ ?>
                                            </a>


                                        </div>
                                    </div>-->

                                        <div class="col-md-12 col-sm-12 col-12 ">
                                            <div class="top-green">
                                                <a data-method="post" class="exit-icon btn-link logout "
                                                   href="<?php echo Yii::$app->homeUrl; ?>site/logout">

                                                    <?= Html::img('@backend/web/images/exit.png'); ?>
                                                    <br>
                                                    <?= Yii::t('app', 'Exit'); ?>

                                                </a>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="Breadcrumbs-box col-12">
                                <?= Breadcrumbs::widget([
                                    'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                                ]) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
            <div class=" content  ">
                <div class="main-content ">
                    <div class="container">
                        <?= Alert::widget() ?>
                        <?= $content ?>
                    </div>
                </div>
            </div>
        </div>

        <div id="print-area"></div>
    </div>


</div>




<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
