<?php

use backend\modules\contract\models\logic\CustomerAttributesLogic;
use backend\modules\gas_liquid\assets\FactoryAsset;
use common\components\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $form yii\widgets\ActiveForm */
/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\logic\FactoryLogic */
/* @var $modelFactoryRegionsNew \backend\modules\gas_liquid\models\logic\FactoryRegionsLogic */
/* @var $modelNewAgent \backend\modules\gas_liquid\models\logic\AgentLogic */
/* @var $modelUserNew \backend\modules\user\models\UserLogic */
/* @var $modeFactoryAgentNew \backend\modules\gas_liquid\models\logic\FactoryAgentsLogic */
/* @var $modelFactoryInvestorNew \backend\modules\gas_liquid\models\logic\FactoryInvestorsLogic */
/* @var $factoryInvestors \backend\modules\gas_liquid\models\logic\FactoryInvestorsLogic[] */
/* @var $modeIdentity \backend\models\logic\IdentityLogic */
/* @var $modelInvestor \backend\modules\gas_liquid\models\logic\FactoryInvestorsLogic */
/* @var $statusList [] */
$this->title = Yii::t('app','Update') .'('. $model->name.')';
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->name, 'url' => ['update', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app','Update').' '.Yii::t('app','Factory');
FactoryAsset::register($this);
?> <div class="Factory-index ">
    <div class="page-head"><i class="icon-header icon-43"></i>

            <?= Html::encode($this->title) ?> </div>
<div class="card card-bg-white"  id="agent-info">

    <div class="row">
        <div class="col-md-4">

            <span>اسم الوكيل :</span>
            <strong>محمد جبار حسين جلاب </strong>
        </div>
        <div class="col-md-2">
            <spna>الحالة :</spna>
            <strong class="text-success"> فعال </strong>

        </div>
        <div class="col-md-3">
            <spna>النوع :</spna>
            <strong >معامل الغاز</strong>

        </div>
        <div class="col-md-3">
            <spna>تاریخ انتهاء العقد :</spna>
            <strong class="number-font">2023/07/31</strong>

        </div>
        
    </div>
 
</div>

<div class="Factory-update card card-bg-white update-div ">
       <div class="factory-form">
                    <div class="row m-0 vertical-right-tab-navs">
                        <div class="col-5 col-sm-3 col-md-2 p-0">
                            <div class="nav flex-column nav-tabs nav-tabs-right h-100" id="vert-tabs-right-tab" role="tablist" aria-orientation="vertical">
                                <a class="nav-link active" id="vert-tabs-right-home-tab" data-toggle="pill" href="#control-sidebar-home-tab" role="tab" aria-controls="vert-tabs-right-home" aria-selected="true"><i class="tab-icon icon-142"></i> <?= Yii::t('app','معلومات عامة') ?></a>
                                <a class="nav-link" id="vert-tabs-right-profile-tab" data-toggle="pill" href="#users-tab" role="tab" aria-controls="vert-tabs-right-profile" aria-selected="false"><i class="tab-icon icon-user111"></i><?= Yii::t('app','Users') ?></a>
                                <a class="nav-link" id="vert-tabs-right-messages-tab" data-toggle="pill" href="#investors-tab" role="tab" aria-controls="vert-tabs-right-messages" aria-selected="false"><i class="tab-icon icon-102"></i><?= Yii::t('app','Investors') ?></a>
                                <a class="nav-link" id="vert-tabs-right-settings-tab" data-toggle="pill" href="#agents-tab" role="tab" aria-controls="vert-tabs-right-settings" aria-selected="false"><i class="tab-icon icon-92"></i><?= Yii::t('app','AgentsGas') ?></a><a class="nav-link" id="vert-tabs-right-settings-tab" data-toggle="pill" href="#contracts-tab" role="tab" aria-controls="vert-tabs-right-settings" aria-selected="false"><i class="tab-icon icon-122"></i><?= Yii::t('app','Contracts') ?></a>
                            </div>
                        </div>
                    <div class="tab-content col-7 col-md-10 p-0 col-sm-9" id="vert-tabs-right-tabContent">
                        <div class="tab-conten-inner" >
                        <div class="tab-pane fade show active" id="control-sidebar-home-tab"  role="tabpanel" aria-labelledby="vert-tabs-right-home-tab">
                            <?= $this->render('_form', [
                                'model' => $model,

                            ]) ?>
                        </div>
                        <div class="tab-pane fade" id="users-tab"  role="tabpanel" aria-labelledby="users-tab">
                            <div class="row">
                                <div class="col-12">
                                    <a class="btn btn-success btn-insert-user"><?= Yii::t('app','Create').' '.Yii::t('app','user') ?></a>
                                </div>
                            </div>
                            <div class="row">

                            <div class="col-12 ">
                                <div class="product-form-group">

                                    <div class="form-group">
                                        <div class="row">
                                            <label class="control-label" for="0"><?= Yii::t('app', 'Users'); ?></label>
                                        </div>
                                    </div>


                                    <?php
                                    $model_user = new \backend\modules\gas_liquid\models\logic\FactoryUserLogic();
                                    $i = 0;
                                    if ($users) {
                                        foreach ($users as $user) {   ?>
                                            <div class="row parent_of_user">
                                                <div class="col-6 pl-0">
                                                    <span class='form-control'><?= $user['name'] ?></span>
                                                </div>
                                                <div class="col-2 parent_of_btn "><span id="<?= $user['user_factory_id']  ?>" title="<?= Yii::t('app', 'Remove'); ?>" class="btn-create2   delete-user addContent" ><i class="fa fa-minus"></i></span>
                                                </div>
                                            </div>
                                            <?php
                                            $i++;
                                        }
                                    }
                                    ?>


                                </div>
                                <?php $form = ActiveForm::begin(); ?>
                                <div class="form-group">
                                    <div class="row parent_of_dropdown">
                                        <div class="col-md-6 col-10 ">
                                            <?php
                                            $model_user = new \backend\modules\gas_liquid\models\logic\FactoryUserLogic();
                                            $i = 1;
                                            echo $form->field($model, "users[$i]")->dropDownList(ArrayHelper::map($model_user->get_user_for_factory_update($model->id), 'id', 'name'), [
                                                'class' => 'form-control users_list', 'prompt' => Yii::t('app', 'Select New User'), 'id' => $i
                                            ])->label(false);
                                            ?>
                                        </div>
                                        <div class="col-2 col-md-2"><span title="<?= Yii::t('app', 'Create'); ?>" data-content="<?= $model->id ?>" id="insert_user"
                                                                          class="btn-create2 addContent "><i class="fa fa-plus"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div id="description-block">
                                </div>
                                <div class="form-group btns-group col-12">
                                    <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                                <?php ActiveForm::end(); ?>
                            </div>
                            </div>
                        </div>
<!--                        <div class="tab-pane" id="regions-tab">-->
<!--                            <div class="row">-->
<!--                                <div class="col-12">-->
<!--                                    --><?php // echo Html::a(Yii::t('app', 'Insert').' '.Yii::t('app', 'Region'), false, ['class' => 'btn btn-success btn-insert-region','data-type'=>$model->id]) ?>
<!--                                </div>-->
<!--                                --><?php //if(isset($factoryRegionsList)){ ?>
<!--                                    <div class="col-12">-->
<!--                                        <table class="table">-->
<!--                                            <thead>-->
<!--                                            <tr>-->
<!--                                                <th>--><?php //echo Yii::t('app', 'Region') ?><!--</th>-->
<!--                                                <th>--><?php //echo Yii::t('app', 'Delete') ?><!--</th>-->
<!--                                            </tr>-->
<!--                                            </thead>-->
<!--                                            <tbody  id="regionList">-->
<!--                                            --><?php //foreach($factoryRegionsList as $factoryRegion){ ?>
<!--                                                <tr>-->
<!--                                                    <td>--><?php //echo $factoryRegion->region; ?><!--</td>-->
<!--                                                    <td>--><?php //echo Html::a('<i class="btn fa fa-trash"></i>',false, ['class' => 'remove-region','id'=>$factoryRegion->id]) ?><!--</td>-->
<!--                                                </tr>-->
<!--                                            --><?php //} ?>
<!--                                            </tbody>-->
<!--                                        </table>-->
<!--                                    </div>-->
<!--                                --><?php //} ?>
<!--                            </div>-->
<!---->
<!--                        </div>-->
                        <div class="tab-pane fade" id="investors-tab"  role="tabpanel" aria-labelledby="investors-tab">
                            <div class="row">
                                <?php if ($factoryInvestors) {?>
                                    <div class="col-12">
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th><?= Yii::t('app','Name') ?></th>
                                                <th><?= Yii::t('app','National Card Number') ?></th>
                                                <th><?= Yii::t('app','Tanker Number') ?></th>
                                                <th><?= Yii::t('app','TankerOwner') ?></th>
                                                <th><?= Yii::t('app','Date') ?></th>
                                                <th><?= Yii::t('app','status') ?></th>
                                                <th><?= Yii::t('app','Action') ?></th>
                                            </tr>
                                            </thead>
                                            <tbody  id="regionList">
                                            <?php foreach ($factoryInvestors as $factoryInvestor) {   ?>
                                                <tr>
                                                    <td><?= $factoryInvestor->investor ?></td>
                                                    <td><?= ($factoryInvestor->identity_id)?$factoryInvestor->identity->national_card_number:'---' ?></td>
                                                    <td><?= $factoryInvestor->tanker_number ?></td>
                                                    <td><?= $factoryInvestor->tanker_owner ?></td>
                                                    <td><?= ($factoryInvestor->created_at)?date('Y/m/d',$factoryInvestor->created_at):'---' ?></td>
                                                    <td><?= $factoryInvestor->getStatus() ?></td>
                                                    <td><?php echo Html::a('<i class="btn fa fa-trash"></i>',['factory-investors/delete','id'=>$factoryInvestor->id], ['class' => 'remove-investor']) ?>
                                                        <?php echo Html::a('<i class="btn fa fa-user"></i>',false, ['class' => 'edit-identity','data'=>$factoryInvestor->id]) ?>
                                                        <?php echo Html::a('<i class="btn fa fa-edit"></i>',false, ['class' => 'edit-investor','data'=>$factoryInvestor->id]) ?></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php } ?>
                                <div class="col-12">
                                    <div class="product-form-group">

                                        <div class="form-group">
                                            <div class="row">
                                                <label class="control-label" for="0"><?= Yii::t('app','Create').' '.Yii::t('app','Investor') ?></label>
                                            </div>
                                        </div>
                                        <?php $form = ActiveForm::begin();
                                        echo $form->field($modelFactoryInvestorNew,'factory_id')->hiddenInput(['value'=>$model->id])->label(false);
                                        ?>
                                        <div class="form-group">
                                            <div class="col-md-4 col-10 ">
                                                <?php
                                                echo $form->field($modelFactoryInvestorNew,'investor' )->textInput();
                                                ?>
                                            </div>
                                            <div class="col-md-4 col-10 ">
                                                <?php
                                                echo $form->field($modelFactoryInvestorNew,'tanker_number' )->textInput();
                                                ?>
                                            </div>
                                            <div class="col-md-4 col-10 ">
                                                <?php
                                                echo $form->field($modelFactoryInvestorNew,'tanker_owner' )->textInput();
                                                ?>
                                            </div>

                                        </div>
                                        <div class="form-group btns-group col-12">
                                            <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                        </div>
                                        <?php ActiveForm::end(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="agents-tab"  role="tabpanel" aria-labelledby="agents-tab">
                            <div class="row">
                                <div class="col-4">
                                    <?= Html::a(Yii::t('app', 'Insert').' '.Yii::t('app', 'Agent'), false, ['class' => 'btn btn-success btn-insert-agent','data-type'=>$model->id]) ?>
                                </div>
                                <div class="col-4">
                                </div>
                                <div class="col-4">
                                    <?php  echo Html::a(Yii::t('app', 'Insert').' '.Yii::t('app', 'Sale Region'), false, ['class' => 'btn btn-success btn-insert-region']) ?>
                                </div>
                                <?php if(isset($factoryAgentList)){ ?>
                                    <div class="col-12">
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th><?= Yii::t('app', 'AgentGas Name') ?></th>
                                                <th><?= Yii::t('app', 'AgentGas Number') ?></th>
                                                <th><?= Yii::t('app', 'Sale Region') ?></th>
                                                <th><?= Yii::t('app', 'Station') ?></th>
                                            </tr>
                                            </thead>
                                            <tbody  id="agentList">
                                            <?php foreach($factoryAgentList as $factoryAgent){ ?>
                                                <tr>
                                                    <td><?= $factoryAgent->agent->name; ?></td>
                                                    <td><?= $factoryAgent->agent->agent_number; ?></td>
                                                    <td><?= ($factoryAgent->region_id)?$factoryAgent->region->region:''; ?></td>
                                                    <td><?= ($factoryAgent->agent->type==\backend\modules\gas_liquid\models\logic\AgentLogic::TYPE_STATION)?$factoryAgent->agent->station->name:''; ?></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php } ?>
                                <div class="col-12">
                                    <div class="product-form-group">

                                        <div class="form-group">
                                            <div class="row">
                                                <label class="control-label" for="0"><?= Yii::t('app','Create').' '.Yii::t('app','Agent').'/'.Yii::t('app','Regions') ?></label>
                                            </div>
                                        </div>
                                        <?php $form = ActiveForm::begin();
                                        echo $form->field($modeFactoryAgentNew,'factory_id')->hiddenInput(['value'=>$model->id])->label(false);
                                        ?>
                                        <div class="form-group">
                                            <div class="col-md-6 col-10 ">
                                                <?php
                                                echo $form->field($modeFactoryAgentNew,'region_id' )->dropDownList(ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryRegionsLogic::getAll(), 'id', 'region'), [
                                                    'class' => 'form-control ', 'prompt' => Yii::t('app', 'Region'),
                                                ])->label(false);
                                                ?>
                                            </div>
                                            <div class="col-md-6 col-10 ">
                                                <?php
                                                echo $form->field($modeFactoryAgentNew,'agent_id' )->dropDownList(ArrayHelper::map(\backend\modules\gas_liquid\models\logic\AgentLogic::getAll(), 'id', 'name'), [
                                                    'class' => 'form-control ', 'prompt' => Yii::t('app', 'Agent'),
                                                ])->label(false);
                                                ?>
                                            </div>

                                        </div>
                                        <div class="form-group btns-group col-12">
                                            <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                        </div>
                                        <?php ActiveForm::end(); ?>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="contracts-tab"     role="tabpanel" aria-labelledby="contracts-tab">
                            <div class="row">
                                <?php if($contractsList){ ?>
                                <?php foreach($contractsList as $attributeId=>$contractType){ ?>

                                        <div class="col-12">
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th colspan="3"><?= CustomerAttributesLogic::getDeterminedAttributesLabel($attributeId) ?></th>

                                            </tr>
                                            </thead>
                                            <tbody  id="agentList">

                                            <?php foreach($contractType as $contracts){ ?>
                                                <tr>
                                                    <td><?= $contracts->change_date; ?></td>
                                                    <td><?= $contracts->changed_value; ?></td>
                                                    <td><?= $contracts->updatedBy->name; ?></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php } ?>
                                <?php } ?>

                            </div>

                        </div>

                    </div>
                    </div>


                </div>
                </div>
            
    </div>
 </div>
<div class="modal fade create-modal" id="UserModal" tabindex="-2" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin(['id'=>'userForm','enableClientValidation' => false,'action'=>['/user/user/create']]); ?>
        <?= Html::hiddenInput('factory_id',$model->id,['id'=>'user_factory_id']); ?>
        <?= $form->field($modelUserNew, 'role')->hiddenInput(['value'=>'factory'])->label(false) ?>
        <?= $form->field($modelUserNew, 'status')->hiddenInput(['value'=>\backend\modules\user\models\UserLogic::STATUS_ACTIVE])->label(false) ?>

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?=Yii::t('app', 'Create'). ' '. Yii::t('app', 'User')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxUser"></p>
                </div>
                <div class="user-form">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'name', ['inputOptions' => ['class' => 'form-control  fa-name']])->textInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">   <?= $form->field($modelUserNew, 'username', ['inputOptions' => ['class' => 'form-control  ']])->textInput() ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'email', ['inputOptions' => ['class' => 'form-control  ']])->textInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'mobile', ['inputOptions' => ['class' => 'form-control ']])->textInput() ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'password', ['inputOptions' => ['class' => 'form-control ']])->passwordInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'confirmPassword', ['inputOptions' => ['class' => 'form-control']])->passwordInput() ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <?= $form->field($modelUserNew, 'description')->textarea(['rows' => 2]); ?>

                        </div>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary register-user"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
</div>
<div class="modal fade create-modal" id="AgentModal" tabindex="-3" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin(['id'=>'agentForm','enableClientValidation' => false]); ?>
        <?php //echo $form->field($modelNewAgent, 'sale_customer_id')->hiddenInput(['value' => $model->id])->label(false); ?>

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?=Yii::t('app', 'Create'). ' '. Yii::t('app', 'AgentsGas')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxAgent"></p>
                </div>
                <div class="row ">
                    <div class="col-md-6">
                        <?= $form->field($modelNewAgent, 'name')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($modelNewAgent, 'id_number')->textInput() ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($modelNewAgent, 'agent_number')->textInput() ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($modelNewAgent, 'tanker_number')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($modelNewAgent, 'capacity')->textInput() ?>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary register-agent"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
</div>
<div class="modal fade create-modal" id="RegionModal" tabindex="-4" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?=Yii::t('app', 'Create'). ' '. Yii::t('app', 'Region')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxRegion"></p>
                </div>
                <div class="row">
                    <div class="col-md-6" id="changed_date_div">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group "><label class="control-label" for=""><?= Yii::t('app', 'Sale Region') ?></label></div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group ">
                                    <?= Html::input('text', 'region',null,['id'=>'factoryregionslogic-region',"class" => "form-control "]) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary " id="register-region"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>



    </div>
</div>
<div class="modal fade create-modal" id="InvestorModal" tabindex="-1" role="dialog"
     aria-labelledby="investorModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="investorModalLabel"><?=Yii::t('app', 'Update'). ' '. Yii::t('app', 'Investor')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php $form = ActiveForm::begin(); ?>
            <?= $form->field($modelInvestor, 'id')->hiddenInput()->label(false); ?>

            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxInvestor"></p>
                </div>
                <div class="investor-form">
                    <div class="row">
                        <div class="col-12">
                            <?= $form->field($modelInvestor, 'investor')->textInput() ?>
                        </div>
                        <div class="col-12">
                            <?= $form->field($modelInvestor, 'tanker_number')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-12">
                            <?= $form->field($modelInvestor, 'tanker_owner')->textInput(['maxlength' => true]) ?>
                        </div>

                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary " id="register-investor"><?= Yii::t('app', 'Save'); ?></button>
            </div>
            <?php ActiveForm::end(); ?>

        </div>



    </div>
</div>
<div class="modal fade create-modal" id="IdentityModal" tabindex="-1" role="dialog"
     aria-labelledby="identityModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="identityModalLabel"><?=Yii::t('app', 'Update'). ' '. Yii::t('app', 'Identity')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php $form = ActiveForm::begin(); ?>

            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxIdentity"></p>
                </div>
                <div class="identity-form">
                    <div class="row">
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'identity_number')->textInput() ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'name')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'father')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'grandfather')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'ancestor')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'surname')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother_father')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother_grandfather')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse_father')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse_grandfather')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'birthday')->textInput() ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'birthplace')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'civil_registry_office')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'sejel')->textInput() ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'sahife')->textInput() ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'governorate')->dropDownList(ArrayHelper::map(\backend\modules\country\models\ProvinceLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'neighborhood')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'locality')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'alley')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'house')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'nearest_reference')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'national_card_number')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'ration_card_number')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-4">
                            <?= $form->field($modeIdentity, 'civil_number')->textInput(['maxlength' => true]) ?>
                        </div>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary " id="register-identity"><?= Yii::t('app', 'Save'); ?></button>
            </div>
            <?php ActiveForm::end(); ?>

        </div>



    </div>
</div>
