<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\gas_liquid\models\search\FactorySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app','Factories');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="factory-logic-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app','Create').' '.Yii::t('app','Factory'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <p>
        <?= Html::a(Yii::t('app','AgentsGas'), ['agent/index'], ['class' => 'btn btn-danger']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="factory-index">
        <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
        <div id="factory-search-info" class="table-box2 ">
            <div class="box-header"> <h3 class="table-title"><?= Html::encode($this->title) ?></h3></div>
            <div class="info-list-div ">
                <table width="100%" class="table table-bordered" border="0">

                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        //'id',
                        'name',
                        //'description:ntext',
                        //'manager_name',
                        //'manager_mobile',
                        //'status',
                        //'city_id',
                        //'created_by',
                        //'created_at',
                        //'updated_at',
                        //'updated_by',
                        //'deleted_at',
                        [
                            'class' => 'yii\grid\ActionColumn',
                            'header' => Yii::t('app', 'عملیات'),
                            'headerOptions' => ['style' => '','class'=>'th-action'],
                            'template' => '{update}{delete}',
                        ]
                    ],
                ]); ?>
                </table>
            </div>
        </div>

</div>
</div>