<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\ArrayHelper;
use backend\modules\country\models\CityLogic;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use backend\modules\user\models\UserLogic;
/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\logic\FactoryLogic */
/* @var $form yii\widgets\ActiveForm */
/* @var $statusList [] */

?>


<?php $form = ActiveForm::begin(
                ['enableClientValidation' => false,]
); ?>
<div class="row">
    <div class="col-md-4">  <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?></div>
    <div class="col-md-4">  <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'city_id')->dropDownList(ArrayHelper::map(CityLogic::getAll(), 'id', 'name'), [
            'prompt' => ''
        ]) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'manager_name')->textInput(['maxlength' => true]) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'manager_mobile')->textInput(['maxlength' => true]) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'status')->dropDownList(FactoryLogic::getStatusList(), ['prompt' => '']) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'tanks_number')->textInput(['maxlength' => true]) ?></div>
    <div class="col-md-4"> <?= $form->field($model, 'tanks_capacity')->textInput(['maxlength' => true]) ?></div>

    <div class="col-12" >
        <?= $form->field($model, 'description')->textarea(['rows' => 3]) ?>
    </div>

    <div class="form-group btns-group col-12">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-success']) ?>
    </div>
</div>

<?php ActiveForm::end(); ?>

