<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\components\ArrayHelper;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use backend\modules\gas_liquid\models\logic\AgentLogic;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */
/* @var $searchModel backend\modules\gas_liquid\models\search\FactorySalesSearch */
/* @var $modelNewSale \backend\modules\gas_liquid\models\logic\FactorySalesLogic */
/* @var $dataProvider yii\data\ActiveDataProvider */

\backend\modules\gas_liquid\assets\FactorySalesAsset::register($this);
$this->title = Yii::t('app','Factories Sales') ;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories'), 'url' => ['factory/index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories Daily Report'), 'url' => ['factory-daily-report/index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factory Sales'), 'url' => ['factory-sales/index']];

?>
<div class="factory-sales-logic-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::button(Yii::t('app','Create').' '. Yii::t('app','Factory Sales'), ['class' => 'btn btn-success btn-show-create-sale']) ?>
    </p>

    <?php echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="info-table-list" id="management-info">
        <div class="info-list-div  ">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                    'attribute'=>'factory_id',
                    'value'=>function($data){return ($data->factory_id)?$data->factory->name:''; },
                    'filter'=>Html::dropDownList('FactorySalesSearch[factory_id]',false,ArrayHelper::map(FactoryLogic::getAll(),'id','name'),['prompt'=>'','class'=>"form-control js-example-basic-multiple"])

            ],
            [
                    'attribute'=>'agent_id',
                    'value'=>function($data){return ($data->agent_id)?$data->agent->name:''; },
                    'filter'=>Html::dropDownList('FactorySalesSearch[agent_id]',false,ArrayHelper::map(AgentLogic::getAll(),'id','name'),['prompt'=>'','class'=>"form-control js-example-basic-multiple"])
            ],
            [
                    'attribute'=>'customer_id',
                    'value'=>function($data){return ($data->customer_id)?$data->customer->name:''; },
                    'filter'=>Html::dropDownList('FactorySalesSearch[customer_id]',false,ArrayHelper::map(\backend\models\logic\CustomerLogic::getAgentAll(),'id','name'),['prompt'=>'','class'=>"form-control js-example-basic-multiple"])
            ],

            //'customer_id',
            //'tanker_number',
            //'region_id',
            'number_capsule',
            [
                'label'=>Yii::t('app','Capacity'),
                'attribute'=>'agent_id',
                'value'=>function($data){return $data->agent->capacity; },

            ],
            [
                'attribute'=>'info_date',
                'value'=>function($data){return $data->info_date; },
                'filter'=> Html::textInput('FactorySalesSearch[info_date]',null,['maxlength' => true, 'class'=>"form-control fa-calendar emptyDatePicker",'data-provide'=>"datepicker"])

            ],
            //'number_capsule',
            //'status',
            //'created_by',
            //'created_at',
            //'updated_at',
            //'updated_by',
            //'deleted_at',

            [
                'class' => 'yii\grid\ActionColumn',
                'header' => Yii::t('app', 'عملیات'),
                'headerOptions' => ['style' => '','class'=>'th-action'],
                'template' => '{sale}',
                'buttons' => [
                    'sale' => function ($url, $model) {
                            return Html::button('<i class="icon icon-edit"></i>',  [
                                'class' => 'btn edit-btn btn-show-create-sale',
                                'data'=>['factory_id'=>$model->factory_id,'agent_id'=>$model->agent_id,'info_date'=>$model->info_date,'number_capsule'=>$model->number_capsule],
                                'title' =>  Yii::t('app','Factory Sales')]);
                    },
                ]
            ]
        ],
    ]); ?>
        </div>
    </div>

</div>
<div class="modal fade create-modal" id="SaleModal" tabindex="-3" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin(['action'=>['create'],'id' => 'saleForm', 'enableClientValidation' => false]); ?>
        <?= $form->field($modelNewSale, 'id')->hiddenInput()->label(false); ?>

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="saleModalLabel"><?= Yii::t('app', 'Create') . ' ' . Yii::t('app', 'Sale') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxSale"></p>
                </div>
                <div class="row ">
                    <div class="col-md-12">
                        <?= $form->field($modelNewSale, 'factory_id')->dropDownList(ArrayHelper::map(FactoryLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-md-12">
                        <?= $form->field($modelNewSale, 'customer_id')->dropDownList(ArrayHelper::map(\backend\models\logic\CustomerLogic::getAgentAll(),'id','name'),['prompt'=>'']) ?>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-md-12">
                        <?= $form->field($modelNewSale, 'info_date')->textInput(['type'=>'date','value'=>$date]) ?>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-md-12">
                        <?= $form->field($modelNewSale, 'number_capsule')->textInput() ?>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary register-sale"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary "
                        data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
</div>
