<?php
use yii\widgets\ActiveForm;
use yii\helpers\Html;
/** @var \backend\modules\gas_liquid\models\logic\AgentLogic[] $agents */
/** @var array $agentList */
/** @var DeepCopy\TypeFilter\Date\ $date */
/** @var \backend\modules\gas_liquid\models\logic\AgentLogic $agentSearched */
$this->title = Yii::t('app', '');

?>
<div class="gasliquid-pages" >
    <div class="card card-sell-send">
        <div class="icon-card-sell"> <?= Html::img('@web/images/icons/gas-icon.png'); ?></div>
        <?php $form = ActiveForm::begin([
            'method' => 'post',
        ]); ?>
        <div class="row m-0" id="card-sell-send-frm">
            <div class="text-right col-md-3 col-sm-3">   <h3>ارسال معلومات البيع</h3></div>
            <div class="col-md-4 inline-form">
                <div class="form-group">
                    <?= Html::dropDownList('agent', $agentSearched, $agentList, ['prompt' => Yii::t('app','اسم الوكيل'), 'class' => 'js-example-basic-multiple  form-control ', 'onchange' => 'this.form.submit()']); ?>
                </div>
            </div>
            <div class="col-md-5 text-left">
                <button title="التحقق" value="التحقق" class=" btn btn-primary ">التحقق</button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
    <?php if($agentSearched){ ?>
    <div class="card card-bg-white"  id="selle-info">

        <div class="row">
            <div class="col-md-3">

                <span>اسم الوكيل :</span>
                <strong><?= $agentSearched->name; ?></strong>
            </div>
            <div class="col-md-1">
                <spna>الحمولة :</spna>
                <strong class="number-font"><?= $agentSearched->capacity; ?></strong>

            </div>
            <div class="col-md-2">
                <spna>رقم الهوية :</spna>
                <strong class="number-font"><?= $agentSearched->agent_number; ?></strong>

            </div>
            <div class="col-md-2">
                <spna>رقم السيارة :</spna>
                <strong><?= $agentSearched->tanker_number; ?></strong>

            </div>
            <div class="col-md-2">
                <spna>منطقه البیع :</spna>
                <strong><?= $agentSearched->region; ?></strong>

            </div>
            <div class="col-md-2">
                <spna>وضعیت :</spna>
                <strong class="text-success"><?= $agentSearched->getStatus(); ?>  </strong>

            </div>
        </div>

        <div class="form-box-d-table green-form-box col-md-7 mb-0" id="Quantity-received-frm">
            <div class="row">
                <div class="col-md-9 inline-form">
                    <div class="form-group">
                        <label class="control-label">الكمية المستلمة :</label>
                        <input id=" " name=" "  class="form-control">

                    </div>
                </div>
                <div class="col-md-3 text-left">
                    <button title="التحقق" value="التحقق" class=" btn btn-success ">تسجیل</button>
                </div>
            </div>

        </div>
    </div>
    <?php } ?>
    <div class="report-list-box ">
        <div class="row">
            <div class="col-md-6 col-sm-5 report-list-title"><h3>قائمة البيع</h3></div>
            <div class="search-listtable col-md-6 col-sm-7">
                <?php $form = ActiveForm::begin([
                    'method' => 'post',
                ]); ?>
                <div class="row m-0">
                    <div class="col-md-4">
                        <div class="form-group">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class=" display-input-flex">
                            <div class="form-group">
                                <input type="date" id="singleDatePicker" class="form-control " name="date" value="<?= ($date)?Date('m/d/Y',strtotime($date)):'' ?>" data-provide="datepicker" >
                            </div>
<!--                            <strong>الي</strong>    <div class="form-group">-->
<!---->
<!--                                <input type="text" id="singleDatePicker"   class="form-control " name="created_at" value="2023-07-26" data-provide="datepicker" onchange="this.form.submit()">             </div>-->
                        </div>
                    </div>
                    <div class="col-md-2 text-center">  <button title="بحث" value=" " class="btn btn-search-blue btn-search-icon">بحث</button></div>

                </div>
                <?php ActiveForm::end(); ?>

            </div>
        </div>



        <div class="table-border-radius">
            <table class="table-head-bg-info  table table-bordered ">
                <thead class=" ">
                <tr>
                    <th>#</th>
                    <th>اسم الوكيل</th>
                    <th>الحمولة</th>
                    <th>رقم الهوية</th>
                    <th>رقم السيارة</th>
                    <th>المقدار</th>
                    <th>التاريخ</th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach($agents as $agentInfo){  ?>
                <tr>
                    <td  class="number-font nowrap-text">1</td>
                    <td><?= $agentInfo->name ?></td>
                    <td  class="number-font nowrap-text"><?= $agentInfo->capacity ?></td>
                    <td  class="number-font nowrap-text"><?= $agentInfo->agent_number ?></td>
                    <td><?= $agentInfo->tanker_number ?></td>
                    <td class="number-font nowrap-text"><?= $agentInfo->lastBuy ?></td>
                    <td class="number-font nowrap-text"><?= ($agentInfo->lastBuyDate)?Date('Y/m/d',strtotime($agentInfo->lastBuyDate)):'' ?></td>
                    <td class="action-btn-td">
                        <?= ($agentInfo->lastBuy)?Html::a('طباعة استمارة 12', ['agent/update','id' =>$agentInfo->id], [
                            "class"=>"print-estemare" ,
                            'target' => '_blank']):'' ?>
                        <?= Html::a('', ['agent/update','id' =>$agentInfo->id], [
                            "class"=>"icon-edit1" ,
                            "title"=>"edit",
                            'target' => '_blank']) ?>
                        <?= Html::a('', ['agent/delete','id' =>$agentInfo->id], [
                            "class"=>"icon-delete" ,
                            "title"=>"حذف",
                            'target' => '_blank']) ?>
                    </td>
                </tr>
                <?php  } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


