<?php

/* @var $this yii\web\View */
/* @var $modelNewDailyReport \backend\modules\gas_liquid\models\logic\FactoryDailyReportLogic */
/* @var $modelNewOrder \backend\modules\gas_liquid\models\logic\FactoryOrdersLogic */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\components\ConvertEnglishDigitToArabic;
use common\components\Digits;
use backend\modules\gas_liquid\models\logic\FactoryLogic;

\backend\modules\gas_liquid\assets\FactoryDailyReportAsset::register($this);
$this->title = Yii::t('app', 'نظام تسجيل وتوزيع غازالسائل ');

$yesterday = date('Y/m/d', strtotime($date . ' -1 day'));

$series = 1;
?>
<div class="gas-liquid-admin-index">
      <div class="gas-liquid-top-bar ">
            <div class="row">
                <div class="col-md-4">
                    <div class="  gas-liquid-search-filters">
                        <?php $form = ActiveForm::begin([
                            'action' => ['index'],
                            'method' => 'post',
                        ]); ?>
                        <div class="row">
                            <div class="col-md-12 inline-form">
                                <div class="form-group">
                                    <label class="control-label"><?= Yii::t('app', 'Factory'); ?></label>
                                    <?= Html::dropDownList('factory_id', $factory, ArrayHelper::map(FactoryLogic::getAll(), 'id', 'name'), ['prompt' => '', 'class' => 'js-example-basic-multiple  form-control ', 'onchange' => 'this.form.submit()']); ?>
                                </div>
                            </div>
                            <div class="col-md-12 inline-form">
                                <div class="form-group">
                                    <label class="control-label"><?= Yii::t('app', 'Date'); ?></label>

                                    <?= Html::textInput('info_date', $date, ['class' => 'form-control ', 'id' => "singleDatePicker", "data-provide" => "datepicker", 'onchange' => 'this.form.submit()']); ?>
                                </div>
                            </div>
                            <div class="col-md-8  inline-form">
                                <div class="form-group">
                                    <?= Html::checkboxList('entry_data', $entry_data_selection, ['1' => Yii::t('app', 'NotSend'), '2' => Yii::t('app', 'Send')], ['prompt' => '', 'class' => '', 'onChecked' => 'this.form.submit()']); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group pt-md-2 btns-group  ">
                                    <?= Html::submitButton(Yii::t('app', 'Search'), ['class' => 'btn  btn-search-icon
                                    btn-search-orange']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
                <div class="col-md-8 gasliquid-panel-main-btns">
                    <div class="row ml-0 ">
                        <div class="col-md-3 pr-1 pl-1  gasliquid-panel-btn">
                            <?php
                            echo Html::a(Yii::t('app', 'factories'), ['/gas_liquid/factory/index'], ['class' => 'btn btn-gasliquid-factory  ']);
                            ?>
                        </div>
                        <div class="col-md-3 pr-1 pl-1 gasliquid-panel-btn">
                            <?php
                            echo Html::a(Yii::t('app', 'agentsGas'), ['/gas_liquid/agent/index'], ['class' => 'btn btn-gasliquid-agentsgas  '])
                            ?>
                        </div>

                        <div class="col-md-3 pr-1 pl-1 gasliquid-panel-btn">
                            <?php
                            echo Html::a(Yii::t('app', 'Factory Sale'), ['/gas_liquid/factory-sales/index'], ['class' => 'btn btn-gasliquid-factorysale  '])
                            ?>
                        </div>
                        <div class="col-md-3 pr-1 pl-1 gasliquid-panel-btn">
                            <?php
                            echo Html::a(Yii::t('app', 'Agent Buy'), ['/gas_liquid/agent/list'], ['class' => 'btn btn-gasliquid-agentbuy  '])
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <div class="gray-box ">
        <div class="row m-0">
            <div class="col-md-6 col-sm-5 report-list-title">
                <h3>موقف التجهیز الیومي للمعامل
                 <span><?= Yii::t('app', 'رقم') . ':' . (date("z") + 1); ?></span>
                </h3>
            </div>
            <div class=" export-div mr-auto text-left">
                <div class="text-center info-date">
                <?php echo Yii::t('app', '') . date('Y/m/d', strtotime($date)); ?>
                </div>
                
                <?php
                //$auth = Yii::$app->authManager;
                //if ($auth->checkAccess(Yii::$app->user->id, RoleLogic::PERMISSION_REPORT_DAILYREPORT))
                echo Html::a(Yii::t('app', ''), ['export', 'info_date' => $date], ['target' => 'blank', 'class' => '    icon icon-file-pdf', 'title' => Yii::t('app', 'Export Pdf')]);

                ?>

                <?php
                echo Html::a(Yii::t('app', ''), false, ['class' => ' icon icon-printer11 mr-2 ml-2 ', 'data' => $date, 'title' => Yii::t('app', 'Print')]);
                ?>
            </div>
        </div>
        <div class="info-gasliquid-table-list" id="factory-daily-report-info">
            <div class="table-border-radius">
                <table class="table-head-bg-yellow table-style-main  table table-bordered ">
                    <thead>
                    <tr class="tr-thead-1">        <th class="num-th" rowspan="2"> <?= Yii::t('app', 'ت'); ?></th>
                        <th class="th-name-info "  rowspan="2" > <?= Yii::t('app', 'اسم المعمل'); ?></th>
                        <th colspan="3" class="name-product text-center name-product"><?php echo $product; ?></th>
                        <th class="action-th" rowspan="2"> <?= Yii::t('app', 'Operations'); ?></th>
                    </tr>
                    <tr class="tr-thead-2">
                   

                        <th class="title-name-product"><?= Yii::t('app', 'الموجود'); ?></th>
                        <th class="title-name-product"><?= Yii::t('app', 'المجهز'); ?></th>
                        <th class="title-name-product "><?= Yii::t('app', 'الوارد'); ?></th>

                    </tr>
                    </thead>
                    <tbody>

                    <?php if ($lists) {
                        foreach ($lists as $list) {
                            $customer_id = $list['id'];
                            if ((!$entry_data) || ($entry_data == '2' && $list['inputData']) || ($entry_data == '1' && !$list['inputData'])) { ?>
                                <tr data-content="<?= $list['id'] ?>" class="tr-parent
                                    <?php if ($list['inputData']) echo 'public-entry';
                                else if (!$list['inputData']) echo ' public-not-entry ';
                                if ($list['status'] == FactoryLogic::OutdatedFactory) echo ' factorylogic-status' ?>">

                                    <td class="num-td"><?= $series++ ?></td>
                                    <td><?= Html::a($list['name'], ['factory/update', 'id' => $list['factory_id']], [
                                            'title' => ((isset($list['description'])) ? $list['description'] : $list['name']), 'target' => '_blank']) ?>
                                    <td class="td-info-stock">
                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['stock']))?Digits::Show_long_numbers($list['stock']):''; ?></a>
                                    </td>
                                    <td class="td-info-input">
                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['input']))?Digits::Show_long_numbers($list['input']):'';?></a>
                                    </td>
                                    <td class="td-info-output">
                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['output']))?Digits::Show_long_numbers($list['output']):'';?></a>
                                    </td>
                                    <!--                                        <td class="td-info-order">-->
                                    <!--                                            <a  class="btn-show-order" title="انشاء طلبية">--><?php //echo (isset($list['order']))?Digits::Show_long_numbers($list['order']):'';?><!--</a>-->
                                    <!--                                        </td>-->

                                    <td class=" action-btn-td" width="46%">
                                        <?php
                                        //                                            echo Html::button('<i class="nav-icon  icon-reportnav-icon text-right  icon-clipboard1"></i>',  [
                                        //                                                'class' => 'btn order-btn btn-show-order',
                                        //                                                'title' => Yii::t('app', 'Register Order')])
                                        ?>
                                        <?php
                                        echo Html::button('<i class=" "></i>'.Yii::t('app', 'Register Daily Report'), [
                                            'class' => 'btn-bg-icon RegisterDailyReport-btn btn-show-daily-report',
                                            'title' => Yii::t('app', 'Register Daily Report')]);

                                        ?>

                                        <?php
                                        echo Html::a('<i class=" "></i>'.Yii::t('app', 'Show factory panel')  , ['factory-panel/index', 'id' => $list['factory_id']], [
                                            'class' => 'btn-bg-icon Show-factory-btn',
                                            'title' => Yii::t('app', 'Show factory panel')])
                                        ?>
                                        <?php
                                        echo Html::a(Yii::t('app', 'Factory Sale Details'), ['factory-sales/index', 'FactorySalesSearch[customer_id]' => $list['id'],'FactorySalesSearch[info_date]' => $date], [
                                            'class' => 'btn-bg-icon   factory-sale-btn',
                                            'title' => Yii::t('app', 'Show factory sale details')])
                                        ?>
                                    </td>
                                </tr>
                            <?php }
                        }
                    } ?>
                    </tbody>

                </table>

            </div>
            <div class="table-border-radius col-12 p-0  mt-2" id="sum-table-box1">

                <table width="100%" cellspacing="0" cellpadding="0" id="sum-table1" class="sum-table1">

                    <thead>
                    <tr>
                        <th class="sum-header-name" colspan="4"><?= Yii::t('app', 'مجموع موقف التجهيز اليومي'); ?> </th>

                    </tr>
                    
                    </thead>
                    <tbody>
                    <tr>
                        <th class="sum-name" ><?= $product ?></th>

                        <td class="td-sum-amount">
                            <b><?= Yii::t('app', 'الموجود'); ?></b>
                              <strong>
                            <?php echo (isset($sum['stock'])) ? Digits::Show_long_numbers($sum['stock']) : '---'; ?>
                              </strong>
                        </td>
                        <td class="td-sum-amount">
                            <b><?= Yii::t('app', 'المجهز'); ?></b>   <strong>
                            <?php echo (isset($sum['input'])) ? Digits::Show_long_numbers($sum['input']) : '---'; ?>
                            </strong>
                        </td>
                        <td class="td-sum-amount">
                            <b><?= Yii::t('app', 'الوارد'); ?></b>   <strong>
                            <?php echo (isset($sum['output'])) ? Digits::Show_long_numbers($sum['output']) : '---'; ?> </strong>
                        </td>
                        <!--                    <td class="td">--><?php //echo (isset($sum['order'])) ? Digits::Show_long_numbers($sum['order']) : '---'; ?><!--</td>-->

                    </tr>
                    </tbody>
                </table>

        </div>
        </div>
    </div>



    <div class="hidden-md-up mobile-view">
        <div class=" col-md-12 index-report-btn  ">
            <div class="row ">
                <div class="col-4">
                    <?php
                    echo Html::a(Yii::t('app', 'factories'), ['gas_liquid/factory/index'], ['class' => 'btn btn-default icon icon-report  mr-2 ml-2']);
                    ?>
                </div>
                <div class="col-4">
                    <?php
                    echo Html::a(Yii::t('app', 'agentsGas'), ['gas_liquid/agent/index'], ['class' => 'btn btn-default icon icon-report-2 mr-2 ml-2'])
                    ?>
                </div>
                <div class="col-4">
                    <?php
                    echo Html::a(Yii::t('app', 'موقف التجهیز الیومي'), false, ['class' => 'btn btn-default btn-print icon icon-printer mr-2 ml-2 ', 'data' => $date]);
                    ?>
                </div>
            </div>
        </div>
        <div class="info-list-div " id="management-info">
            <?php
            $cc = 1;
            if ($lists) {
                foreach ($lists as $list) {
                    $customer_id = $list['id'];
                        ?>

                        <div class="col-12  list-items order-dashboard-list col-md-6">
                            <div id="list-inner" class="row
                            <?php if ($list['inputData']) echo 'public-entry';
                            else if (!$list['inputData']) echo 'public-not-entry';
                            if ($list['status'] == FactoryLogic::OutdatedFactory) echo ' factorylogic-status' ?>
                                    <?php if (isset($list['unpaidFineOnIllegalTime']) || isset($list['deposit'])) echo ' pay-not-fine'; ?>">
                                <div class=" col-sm-12  col-md-12  warehouse-dashboard-info management-dashboard-info">
                                    <div class="row">
                                        <div class="code-name col-12 ">
                                            <div class="row m-0">
                                                <div class="col col-12">
                                                    <span class="counter"><?= $cc++ ?></span>
                                                    <h5>
                                                        <?= Html::a($list['name'], ['factory/update', 'id' => $list['factory_id']], [
                                                            'title' => ((isset($list['description'])) ? $list['description'] : $list['name']), 'target' => '_blank']) ?>
                                                    </h5>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12 col-sm-12 p-0">
                                            <div class="row  info-management">
                                                <div class="col-12">
                                                    <div class="table-head2">
                                                        <div class="row  m-0">
                                                            <div class="col-12">
                                                                <div class="row">
                                                                    <div class="col-3"><?= Yii::t('app', 'الموجود'); ?></div>
                                                                    <div class="col-3"><?= Yii::t('app', 'المجهز'); ?></div>
                                                                    <div class="col-3"><?= Yii::t('app', 'الوارد'); ?></div>
                                                                    <div class="col-3"><?= Yii::t('app', 'الطلب'); ?> </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="table-body2">
                                                        <?php $i = 0;
                                                        if (isset($list)) {
                                                            ?>
                                                            <div class="row m-0">
                                                            <div class="col-12">
                                                                <div class="row">
                                                                    <div class="col-4 col-number">
                                                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['stock']))?Digits::Show_long_numbers($list['stock']):''; ?></a>
                                                                    </div>
                                                                    <div class="col-4 col-number">
                                                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['input']))?Digits::Show_long_numbers($list['input']):'';?></a>
                                                                    </div>
                                                                    <div class="col-4 col-number">
                                                                        <a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي"><?= (isset($list['output']))?Digits::Show_long_numbers($list['output']):'';?></a>
                                                                    </div>
<!--                                                                    <div class="col-3 col-number">-->
<!--                                                                        <a  class="btn-show-order" title="انشاء طلبية">--><?php //echo (isset($list['order']))?Digits::Show_long_numbers($list['order']):'';?><!--</a>-->
<!--                                                                    </div>-->
                                                                </div>
                                                            </div>

                                                            </div><?php
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                                <div class="col-12 action-btn">

                                                    <?php
//                                                    echo Html::button('<i class="nav-icon  icon-reportnav-icon text-right  icon-clipboard1"></i>',  [
//                                                        'class' => 'btn order-btn btn-show-order',
//                                                        'title' => Yii::t('app', 'Register Order')])
                                                    ?>
                                                    <?php
                                                    echo Html::button('<i class="nav-icon  icon-graph"></i>', [
                                                        'class' => 'btn DailyReport-btn btn-show-daily-report',
                                                        'title' => Yii::t('app', 'Register Daily Report')]);

                                                    ?>

                                                    <?php
                                                    echo Html::a('<i class="nav-icon  icon-report"></i>', ['factory-panel/index', 'id' => $list['factory_id']], [
                                                        'class' => 'btn Show-factory-btn',
                                                        'title' => Yii::t('app', 'Show factory panel')])
                                                    ?>
                                                    <?php
                                                    echo Html::a(Yii::t('app', 'Factory Sale Details'), ['factory-sales/index', 'FactorySalesSearch[customer_id]' => $list['id'],'FactorySalesSearch[info_date]' => $date], [
                                                        'class' => 'btn btn-default Show-factory-btn',
                                                        'title' => Yii::t('app', 'Show factory sale details')])
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                }
            } ?>


        </div>

        <div class="col-12 p-0  divanieh-sum mobile-table-footer" id="sum-table-box">

            <table width="100%" cellspacing="0" cellpadding="0" class="sum-table totoal-sum-table"
                   id="sum-table-mobile">
                <thead>
                <tr>
                    <th class="sum-name" colspan="4"><?= Yii::t('app', 'المجموع'); ?> </th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <th colspan=""><?= Yii::t('app', 'الموجود'); ?></th>
                    <th colspan=""><?= Yii::t('app', 'المجهز'); ?></th>
                    <th colspan=""><?= Yii::t('app', 'الوارد'); ?></th>
<!--                    <th colspan="">--><?php //echo Yii::t('app', 'الطلبية'); ?><!--</th>-->
                </tr>
                <tr>
                    <td class="td"><?php echo (isset($sum['stock'])) ? Digits::Show_long_numbers($sum['stock']) : '---'; ?></td>
                    <td class="td"><?php echo (isset($sum['input'])) ? Digits::Show_long_numbers($sum['input']) : '---'; ?></td>
                    <td class="td"><?php echo (isset($sum['output'])) ? Digits::Show_long_numbers($sum['output']) : '---'; ?></td>
<!--                    <td class="td">--><?php //echo (isset($sum['order'])) ? Digits::Show_long_numbers($sum['order']) : '---'; ?><!--</td>-->
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!--
<dialog class="modal  A4" id="preview-modal-order" tabindex="-1" style="size: A4">

    <section class="sheet">
        <div class="print-wrapper  A4" id="print-info">
            <style media="print">

                @page {
                    margin-top: 0.8cm;
                    margin-bottom: 0.5cm;
                    padding: 0;
                    size: A4 portrait;
                    margin-right: 0cm !important;
                    margin-left: 0.9cm !important;
                }

            </style>
            <?/*= $this->render('export', [
                'customer' => $customer,
                'lists' => $lists,
                'date' => $date,
                'sum' => $sum,
                'entry_data' => $entry_data,
                'product'=>$product,
            ]) */?>
        </div>
    </section>

</dialog>

-->
<div class="modal fade create-modal" id="DailyReportModal" tabindex="-2" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin(['id' => 'dailyReportForm', 'enableClientValidation' => false]); ?>
        <?= $form->field($modelNewDailyReport, 'customer_id')->hiddenInput()->label(false); ?>
        <?= $form->field($modelNewDailyReport, 'info_date')->hiddenInput(['value'=>$date])->label(false); ?>
        <?= $form->field($modelNewDailyReport, 'id')->hiddenInput()->label(false); ?>

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="dailyReportModalLabel"><?= Yii::t('app', 'Create') . ' ' . Yii::t('app', 'Dailyreport') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxDailyReport"></p>
                </div>
                <div class="row ">
                    <div class="col-md-12">
                        <?= $form->field($modelNewDailyReport, 'stock')->textInput() ?>
                    </div>
                    <div class="col-md-12">
                        <?= $form->field($modelNewDailyReport, 'input')->textInput() ?>
                    </div>
                    <div class="col-md-12">
                        <?= $form->field($modelNewDailyReport, 'output')->textInput() ?>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary register-daily-report"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary "
                        data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
</div>
 