<?php

/* @var $this yii\web\View */
/* @var $modelNewDailyReport \backend\modules\gas_liquid\models\logic\FactoryDailyReportLogic */
/* @var $modelNewOrder \backend\modules\gas_liquid\models\logic\FactoryOrdersLogic */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\components\ConvertEnglishDigitToArabic;
use common\components\Digits;
use backend\modules\gas_liquid\models\logic\FactoryLogic;

\backend\modules\gas_liquid\assets\FactoryDailyReportAsset::register($this);
$this->title = Yii::t('app', 'نظام تسجيل وتوزيع غازالسائل ');

$yesterday = date('Y/m/d', strtotime($date . ' -1 day'));

?>
<div class="print-size-A4 " id="index-report-print">
    <div id="index-report-header"
         class="print-header index-report-header-divanieh col-12 index_report-karbala ">

        <div class="row m-0">
            <div class="col-10 print-page-title"><?= Yii::t('app', 'موقف التجهیز الیومي للمعامل '); ?>
                <span class=" print-page-date "> <?php echo($yesterday); ?>
                        </span>
            </div>
            <div class="col-sm-2 col-md-2 col-2  text-left"><?= Yii::t('app', 'رقم') . ':' . (date("z") + 1); ?></div>

        </div>
    </div>
    <div id="index_report-content" class="print-content index_report-divanieh ">
        <div id="management-info" class=" col-12">
            <table width="100%" id="management-info-table" border="2" cellspacing="0" cellpadding="0">

                <thead>
                <tr>
                    <th class="num-th" rowspan="2"><?= Yii::t('app', 'ت'); ?></th>
                    <th class="name-mahate " rowspan="2" colspan="">
                        <?= Yii::t('app', 'اسم المحطة'); ?>
                    </th>
                    <th class="name-product " colspan="3"><?php echo $product; ?></th>
                </tr>
                <tr>
                    <td class="item-product td-head"><?= Yii::t('app', 'الموجود'); ?></td>
                    <td class="item-product td-head"><?= Yii::t('app', 'المجهز'); ?></td>
                    <td class="item-product td-head"><?= Yii::t('app', 'الوارد'); ?></td>
                    <!--                                <td class="item-product td-head---><?php //echo $i ?><!-- item-last">--><?php //echo Yii::t('app', 'الطلبیة'); ?><!-- </td>-->
                </tr>


                </thead>
                <tbody>

                <?php $j = 0;
                $b = 1;
                if($lists){
                foreach ($lists as $list) {
                    ?>
                    <tr>
                        <td class="num-td"><?= $b++ ?></td>
                        <th class="name-mahate "><?= $list['name']; ?></th>
                        <td class="product-item-numbers  product-item-numbers-first product-item-numbers"><?= (isset($list['stock'])) ? Digits::Show_long_numbers($list['stock']) : '---'; ?></td>
                        <td class="product-item-numbers  product-item-numbers"><?= (isset($list['input'])) ? Digits::Show_long_numbers($list['input']) : '---'; ?></td>
                        <td class="product-item-numbers   product-item-numbers"><?= (isset($list['output'])) ? Digits::Show_long_numbers($list['output']) : '---'; ?></td>
                        <!--                                    <td class="product-item-numbers  product-item-numbers-last   product-item-numbers"> --><?php //echo (isset($list['order'])) ? Digits::Show_long_numbers($list['order']) : '---'; ?><!--</td>-->
                    </tr>
                <?php }} ?>

                <tr class="sum-row sum-row2  total-sum">
                    <th class="sum-head-th" colspan="2"><?= Yii::t('app', 'المجموع'); ?></th>

                    <td class=" sum-col sum1   first sum-col"><?php echo (isset($sum['stock'])) ? Digits::Show_long_numbers($sum['stock']) : '---'; ?></td>
                    <td class=" sum-col sum2 sum-col"><?php echo (isset($sum['input'])) ? Digits::Show_long_numbers($sum['input']) : '---'; ?></td>
                    <td class=" sum-col sum3 sum-col"><?php echo (isset($sum['output'])) ? Digits::Show_long_numbers($sum['output']) : '---'; ?></td>
                    <!--                                <td class=" sum-col sum4  last sum-col">--><?php //echo (isset($sum['order'])) ? Digits::Show_long_numbers($sum['order']) : '-'; ?><!--</td>-->
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

