<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\logic\FactoryAgentsLogic */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Factory Agents Logics', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="factory-agents-logic-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'factory_id',
            'agent_id',
            'region_id',
            'status',
            'created_by',
            'created_at',
            'updated_at',
            'updated_by',
            'deleted_at',
        ],
    ]) ?>

</div>
