<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\activeRecord\Agent */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','AgentsGas'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="agent-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            'agent_number',
            'tanker_number',
            'effective_date',
            'safety_date',
            'air_conditioning_date',
            'capacity',
//            'sale_customer_id',
//            'sale_region',
            'status',
            'sort',
            'city_id',
            [
                'attribute'=>'updated_by',
                'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
            ],
            [
                'attribute'=>'updated_at',
                'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
            ],
            [
                'attribute'=>'created_by',
                'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
            ],
            [
                'attribute'=>'created_at',
                'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
            ],
        ],
    ]) ?>

</div>
