<?php

use backend\modules\contract\models\logic\CustomerAttributesLogic;
use backend\modules\gas_liquid\assets\AgentAsset;
use common\components\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\activeRecord\Agent */
/* @var $modeIdentity \backend\models\logic\IdentityLogic */
/* @var $modeFactoryAgentNew \backend\modules\gas_liquid\models\logic\FactoryAgentsLogic */

$this->title = Yii::t('app','Update').' '. $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories'), 'url' => ['factory/index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','AgentsGas'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('app','Update').' '.Yii::t('app','AgentGas');

AgentAsset::register($this);
?>
<div class="agent-update  create-div container">
    <div class="create-form-box col-md-12">
        <h2 class="form-head">
            <?= Html::encode($this->title) ?>
        </h2>
        <div class="row">
            <div class="create-form-inner" id="termonal-create">
                <div class="factory-form">
                <ul class="nav nav-tabs control-sidebar-tabs">
                    <li><a href="#control-sidebar-home-tab" data-toggle="tab" class="active"><?= Yii::t('app','معلومات عامة') ?></a></li>
                    <li><a href="#identity-tab" data-toggle="tab"><?= Yii::t('app','تصاريح امنية') ?></a></li>
                    <li><a href="#users-tab" data-toggle="tab"><?= Yii::t('app','Users') ?></a></li>
                    <li><a href="#factory-tab" data-toggle="tab"><?= Yii::t('app','Factory') ?></a></li>
                    <li><a href="#contracts-tab" data-toggle="tab"><?= Yii::t('app','Contracts') ?></a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="control-sidebar-home-tab">
                        <?= $this->render('_form', [
                            'model' => $model,

                        ]) ?>
                    </div>
                    <div class="tab-pane" id="identity-tab">
                        <div class="identity-form">
                        <?php $form = ActiveForm::begin(); ?>
                        <div class="row">
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'identity_number')->textInput() ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'name')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'father')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'grandfather')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'ancestor')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'surname')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother_father')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'mother_grandfather')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse_father')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'spouse_grandfather')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'birthday')->textInput() ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'birthplace')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'civil_registry_office')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'sejel')->textInput() ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'sahife')->textInput() ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'governorate')->dropDownList(ArrayHelper::map(\backend\modules\country\models\ProvinceLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'neighborhood')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name'),['prompt'=>'']) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'locality')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'alley')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'house')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'nearest_reference')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'national_card_number')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'ration_card_number')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-4">
                            <?= $form->field($modeIdentity, 'civil_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <?= Html::submitButton(Yii::t('app','Save'), ['class' => 'btn btn-success']) ?>
                            </div>
                        </div>

                            <?php ActiveForm::end(); ?>

                        </div>

                    </div>
                    <div class="tab-pane" id="users-tab">
                        <div class="row">
                            <div class="col-12">
                                <a class="btn btn-success btn-insert-user"><?= Yii::t('app','Create').' '.Yii::t('app','user') ?></a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 ">
                                <div class="product-form-group">

                                    <div class="form-group">
                                        <div class="row">
                                            <label class="control-label" for="0"><?= Yii::t('app', 'Users'); ?></label>
                                        </div>
                                    </div>
                                    <?php
                                    $model_user = new \backend\modules\gas_liquid\models\logic\AgentUserLogic();
                                    $i = 0;
                                    if ($users) {
                                        foreach ($users as $user) {   ?>
                                            <div class="row parent_of_user">
                                                <div class="col-6 pl-0">
                                                    <span class='form-control'><?= $user['name'] ?></span>
                                                </div>
                                                <div class="col-2 parent_of_btn "><span id="<?= $user['user_agent_id']  ?>" title="<?= Yii::t('app', 'Remove'); ?>" class="btn-create2   delete-user addContent" ><i class="fa fa-minus"></i></span>
                                                </div>
                                            </div>
                                            <?php
                                            $i++;
                                        }
                                    }
                                    ?>
                                </div>
                                <?php $form = ActiveForm::begin(); ?>
                                <div class="form-group">
                                    <div class="row parent_of_dropdown">
                                        <div class="col-md-6 col-10 ">
                                            <?php
                                            $model_user = new \backend\modules\gas_liquid\models\logic\AgentUserLogic();
                                            $i = 1;
                                            echo $form->field($model, "users[$i]")->dropDownList(ArrayHelper::map($model_user->get_user_for_agent(), 'id', 'name'), [
                                                'class' => 'form-control users_list', 'prompt' => Yii::t('app', 'Select New User'), 'id' => $i
                                            ])->label(false);
                                            ?>
                                        </div>
                                        <div class="col-2 col-md-2"><span title="<?= Yii::t('app', 'Create'); ?>" data-content="<?= $model->id ?>" id="insert_user"
                                                                          class="btn-create2 addContent "><i class="fa fa-plus"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div id="description-block">
                                </div>
                                <div class="form-group btns-group col-12">
                                    <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                                <?php ActiveForm::end(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="factory-tab">
                        <div class="row">
                                    <?php if ($factoryRegions) {?>
                                        <div class="col-12">
                                            <table class="table">
                                                <thead>
                                                <tr>
                                                    <th><?= Yii::t('app','Factory') ?></th>
                                                    <th><?= Yii::t('app','Region') ?></th>
                                                    <th><?= Yii::t('app','Date') ?></th>
                                                    <th><?= Yii::t('app','status') ?></th>
                                                    <th><?= Yii::t('app','Delete') ?></th>
                                                </tr>
                                                </thead>
                                                <tbody  id="regionList">
                                                <?php foreach ($factoryRegions as $factoryRegion) {   ?>
                                                    <tr>
                                                        <td><?= ($factoryRegion->factory_id)?$factoryRegion->factory->name:'---' ?></td>
                                                        <td><?= ($factoryRegion->region_id)?$factoryRegion->region->region:'---' ?></td>
                                                        <td><?= ($factoryRegion->created_at)?date('Y/m/d',$factoryRegion->created_at):'---' ?></td>
                                                        <td><?= $factoryRegion->getStatus() ?></td>
                                                        <td><?php echo Html::a('<i class="btn fa fa-trash"></i>',false, ['class' => 'remove-region','id'=>$factoryRegion->id]) ?></td>
                                                    </tr>
                                                <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    <?php } ?>
                            <div class="col-12">
                            <div class="product-form-group">

                                    <div class="form-group">
                                        <div class="row">
                                            <label class="control-label" for="0"><?= Yii::t('app','Create').' '.Yii::t('app','Factory').'/'.Yii::t('app','Regions') ?></label>
                                        </div>
                                    </div>
                                    <?php $form = ActiveForm::begin();
                                    echo $form->field($modeFactoryAgentNew,'agent_id')->hiddenInput(['value'=>$model->id])->label(false);
                                    ?>
                                    <div class="form-group">
                                        <div class="col-md-6 col-10 ">
                                            <?php
                                            echo $form->field($modeFactoryAgentNew,'region_id' )->dropDownList(ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryRegionsLogic::getAll(), 'id', 'region'), [
                                                'class' => 'form-control', 'prompt' => Yii::t('app', 'Region'),
                                            ])->label(false);
                                            ?>
                                        </div>
                                        <div class="col-md-6 col-10 ">
                                            <?php
                                            echo $form->field($modeFactoryAgentNew,'factory_id' )->dropDownList(ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryLogic::getAll(), 'id', 'name'), [
                                                'class' => 'form-control', 'prompt' => Yii::t('app', 'Factory'),
                                            ])->label(false);
                                            ?>
                                        </div>

                                    </div>
                                    <div class="form-group btns-group col-12">
                                        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                    </div>
                                    <?php ActiveForm::end(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="contracts-tab">
                        <div class="row">
                            <?php if($contractsList){ ?>
                                <?php foreach($contractsList as $attributeId=>$contractType){ ?>

                                    <div class="col-12">
                                        <table class="table">
                                            <thead>
                                            <tr>
                                                <th colspan="3"><?= CustomerAttributesLogic::getDeterminedAttributesLabel($attributeId) ?></th>

                                            </tr>
                                            </thead>
                                            <tbody  id="agentList">

                                            <?php foreach($contractType as $contracts){ ?>
                                                <tr>
                                                    <td><?= $contracts->change_date; ?></td>
                                                    <td><?= $contracts->changed_value; ?></td>
                                                    <td><?= $contracts->updatedBy->name; ?></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                        </div>

                    </div>
                </div>
                </div>
        </div>
    </div>
</div>
</div>
<div class="modal fade create-modal" id="UserModal" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin(['id'=>'userForm','enableClientValidation' => false,'action'=>['/user/user/create']]); ?>
        <?= Html::hiddenInput('agent_id',$model->id,['id'=>'user_agent_id']); ?>
        <?= $form->field($modelUserNew, 'role')->hiddenInput(['value'=>'agent'])->label(false) ?>
        <?= $form->field($modelUserNew, 'status')->hiddenInput(['value'=>\backend\modules\user\models\UserLogic::STATUS_ACTIVE])->label(false) ?>

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?=Yii::t('app', 'Create'). ' '. Yii::t('app', 'User')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxUser"></p>
                </div>
                <div class="user-form">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'name', ['inputOptions' => ['class' => 'form-control  fa-name']])->textInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">   <?= $form->field($modelUserNew, 'username', ['inputOptions' => ['class' => 'form-control  ']])->textInput() ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'email', ['inputOptions' => ['class' => 'form-control  ']])->textInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'mobile', ['inputOptions' => ['class' => 'form-control ']])->textInput() ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'password', ['inputOptions' => ['class' => 'form-control ']])->passwordInput() ?>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <?= $form->field($modelUserNew, 'confirmPassword', ['inputOptions' => ['class' => 'form-control']])->passwordInput() ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <?= $form->field($modelUserNew, 'description')->textarea(['rows' => 2]); ?>

                        </div>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary register-user"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
</div>
