<?php

use yii\grid\GridView;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\gas_liquid\models\search\AgentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $messageForm \backend\modules\gas_liquid\models\form\MessageForm */

$this->title = Yii::t('app', 'Agent Buy');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories'), 'url' => ['factory/index']];
$this->params['breadcrumbs'][] = $this->title;

\backend\modules\gas_liquid\assets\AgentAsset::register($this);
?>
<div class="agent-index">


    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="factory-index">
        <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
        <div id="factory-search-info" class="table-box2 ">
            <div class="box-header"> <h3 class="table-title"><?= Html::encode($this->title) ?></h3></div>
            <div class="info-list-div ">
                <table width="100%" class="table table-bordered" border="0">
                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        'name',
                        'agent_number',
                        [
                            'label'=>Yii::t('app','Mobile'),
                            'attribute'=>'customer',
                            'value'=>function($data){return (isset($data->customer))?$data->customer->manager_mobile:'---';},
                        ],
                        [
                            'filter'=>\backend\modules\gas_liquid\models\logic\AgentLogic::getStatusList(),
                            'attribute'=>'status',
                            'value'=>function($data){return (isset($data->status))?$data->getStatus():'';},
                        ],
                        [
                            'attribute'=>'lastBuy',
                            'value'=>function($data){return ($factorySale=$data->getLastBuy())?$factorySale->number_capsule:'---';},
                        ],
                        [
                            'attribute'=>'lastBuyDate',
                            'value'=>function($data){return ($factorySale=$data->getLastBuy())?$factorySale->info_date:'---';},
                        ],
//                        //'tanker_number',
                        //'effective_date',
                        //'safety_date',
                        //'air_conditioning_date',
                        //'capacity',
//                        [
//                            'filter'=>ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryLogic::getAll(),'id','name'),
//                            'attribute'=>'sale_customer_id',
//                            'value'=>function($data){return $data->factory->name;},
//                        ],
//                        [
//                            'filter'=>ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryRegionsLogic::getAll(),'id','region'),
//                            'attribute'=>'sale_region',
//                            'value'=>function($data){return $data->region->region;},
//                        ],
                        //'status',
                        //'sort',
                        //'city_id',
//                        [
//                            'attribute'=>'updated_by',
//                            'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
//                        ],
//                        [
//                            'attribute'=>'updated_at',
//                            'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
//                        ],
//                        [
//                            'attribute'=>'created_by',
//                            'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
//                        ],
//                        [
//                            'attribute'=>'created_at',
//                            'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
//                        ],

                        [
                            'class' => 'yii\grid\ActionColumn',
                            'header' => Yii::t('app', 'عملیات'),
                            'headerOptions' => ['style' => '','class'=>'th-action'],
                            'template' => '{whatsApp}{agentPanel}',
                            'buttons' => [
                                'whatsApp' => function ($url, $model) {
                                    return  Html::button(Yii::t('app','Send Message'), [
                                        'class' => 'btn whatsapp-btn',
                                        'data-id'=> $model->id,
                                        'title' => Yii::t('app', 'Send Whatsapp Message'),
                                        'style'=>($model->customer && $model->customer->manager_mobile)?'display:block':'display:none'
                                    ]);
                                },
                                'agentPanel' => function ($url, $model) {
                                    return Html::a(Yii::t('app','Agent Panel'), ['/gas_liquid/agent-panel/index', 'id' => $model->id], [
                                        'class' => 'btn edit-btn',
                                        'title' => Yii::t('app', 'Update')]);
                                },
                            ],
                        ] ,
                        [
                            'class' => 'yii\grid\ActionColumn',
                            'header' => Yii::t('app', 'عملیات'),
                            'headerOptions' => ['style' => '','class'=>'th-action'],
                            'template' => '{update}{delete}',
                        ]
                    ],
                ]); ?>
                </table>
            </div>
        </div>
    </div>
</div>
<!----------------------------------------------------Message-----------------------------!-->
<div class="modal" id="messageModal" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <?php $form = ActiveForm::begin([]); ?>
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?= Yii::t('app', 'send Message') . ' #'  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= $form->field($messageForm, 'agent')->hiddenInput()->label(false); ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group ">
                            <?= $form->field($messageForm, 'user')->dropDownList([],["class" => "form-control "]) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <?= $form->field($messageForm, 'phone')->input(["class" => "form-control"]) ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <?= $form->field($messageForm, 'message_type')->dropDownList($messageForm->getMessage_type(),["class" => "form-control"]) ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <?= $form->field($messageForm, 'message')->textArea(["class" => "form-control ",'rows'=>13]) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary send-message"><?= Yii::t('app', 'Send Message'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>
