<?php

use yii\helpers\Html;
use yii\grid\GridView;
Use common\components\ArrayHelper;
/* @var $this yii\web\View */
/* @var $searchModel backend\modules\gas_liquid\models\search\AgentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app','AgentsGas');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app','Factories'), 'url' => ['factory/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="agent-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app','Create').' '.Yii::t('app','AgentGas'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="factory-index">
        <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
        <div id="factory-search-info" class="table-box2 ">
            <div class="box-header"> <h3 class="table-title"><?= Html::encode($this->title) ?></h3></div>
            <div class="info-list-div ">
                <table width="100%" class="table table-bordered" border="0">
                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],

                        'id',
                        'name',
                        'agent_number',
                        'tanker_number',
                        //'effective_date',
                        //'safety_date',
                        //'air_conditioning_date',
                        //'capacity',
//                        [
//                            'filter'=>ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryLogic::getAll(),'id','name'),
//                            'attribute'=>'sale_customer_id',
//                            'value'=>function($data){return $data->factory->name;},
//                        ],
//                        [
//                            'filter'=>ArrayHelper::map(\backend\modules\gas_liquid\models\logic\FactoryRegionsLogic::getAll(),'id','region'),
//                            'attribute'=>'sale_region',
//                            'value'=>function($data){return $data->region->region;},
//                        ],
                        //'status',
                        //'sort',
                        //'city_id',
//                        [
//                            'attribute'=>'updated_by',
//                            'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
//                        ],
//                        [
//                            'attribute'=>'updated_at',
//                            'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
//                        ],
//                        [
//                            'attribute'=>'created_by',
//                            'value'=>function($model){return (isset($model->created_by))?$model->createdBy->name:'';},
//                        ],
//                        [
//                            'attribute'=>'created_at',
//                            'value'=>function($model){return (isset($model->created_at))?Date('Y/m/d',$model->created_at):'';},
//                        ],

                        [
                            'class' => 'yii\grid\ActionColumn',
                            'header' => Yii::t('app', 'عملیات'),
                            'headerOptions' => ['style' => '','class'=>'th-action'],
                            'template' => '{update}{delete}',
                        ]
                    ],
                ]); ?>
                </table>
            </div>
        </div>
    </div>
</div>

