<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\ArrayHelper;
use backend\modules\gas_liquid\assets\AgentAsset;
/* @var $this yii\web\View */
/* @var $model backend\modules\gas_liquid\models\logic\AgentLogic */
/* @var $form yii\widgets\ActiveForm */

AgentAsset::register($this);

?>


    <?php $form = ActiveForm::begin(
        ['enableClientValidation' => false,]
    ); ?>
    <div class="row ">
        <div class="col-md-4">
            <?= $form->field($model, 'agent_number')->textInput() ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'id_number')->textInput() ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'tanker_number')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'mobile')->textInput() ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'address')->textInput() ?>
        </div>



<!--        <div class="col-md-6">-->
<!--            --><?php //echo $form->field($model, 'type')->dropDownList($model::getTypeList()) ?>
<!--        </div>-->

            <div class="col-md-4">
                <?= $form->field($model, 'capacity')->textInput() ?>
            </div>
            <div class="col-md-4">
                <?= $form->field($model, 'effective_date')->textInput(['class'=>'form-control emptyDatePicker']) ?>
            </div>
            <div class="col-md-4">
                <?= $form->field($model, 'safety_date')->textInput(['class'=>'form-control emptyDatePicker']) ?>
            </div>
            <div class="col-md-4">
                <?= $form->field($model, 'air_conditioning_date')->textInput(['class'=>'form-control emptyDatePicker']) ?>
            </div>
        <div class="col-md-4">
            <?= $form->field($model, 'city_id')->dropDownList(ArrayHelper::map(\backend\modules\country\models\CityLogic::getAll(),'id','name')) ?>
        </div>
        <div class="col-md-4">
                <?= $form->field($model, 'status')->dropDownList(\backend\modules\gas_liquid\models\logic\AgentLogic::getStatusList()) ?>
            </div>

        <div class="form-group btns-group col-12">
        <?= Html::submitButton(Yii::t('app','Save'), ['class' => 'btn btn-success']) ?>
        <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-success']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>
<div class="modal fade create-modal" id="RegionModal" tabindex="-1" role="dialog"
     aria-labelledby="exampleModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"
                    id="exampleModalLabel"><?=Yii::t('app', 'Create'). ' '. Yii::t('app', 'Region')  ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <p id="messageBoxRegion"></p>
                </div>
                <div class="row">
                    <div class="col-md-6" id="changed_date_div">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group "><label class="control-label" for=""><?= Yii::t('app', 'Sale Region') ?></label></div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group ">
                                    <?= Html::input('text', 'region',null,['id'=>'factoryregionslogic-region',"class" => "form-control "]) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary " id="register-region"><?= Yii::t('app', 'Save'); ?></button>
                <button type="button" class="btn btn-secondary " data-dismiss="modal"><?= Yii::t('app', 'Close'); ?></button>
            </div>
        </div>



    </div>
</div>
