<?php

namespace backend\modules\gas_liquid\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\gas_liquid\models\logic\FactorySalesLogic;

/**
 * FactorySalesSearch represents the model behind the search form of `backend\modules\gas_liquid\models\logic\FactorySalesLogic`.
 */
class FactorySalesSearch extends FactorySalesLogic
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'factory_id', 'agent_id', 'customer_id', 'region_id', 'number_capsule', 'status', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['tanker_number', 'info_date', 'amount'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FactorySalesLogic::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'factory_id' => $this->factory_id,
            'agent_id' => $this->agent_id,
            'customer_id' => $this->customer_id,
            'region_id' => $this->region_id,
            'info_date' => $this->info_date,
            'number_capsule' => $this->number_capsule,
            'status' => $this->status,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
            'deleted_at' => 0,
        ]);

        $query->andFilterWhere(['like', 'tanker_number', $this->tanker_number])
            ->andFilterWhere(['like', 'amount', $this->amount]);

        $query->orderBy=array('info_date'=>SORT_DESC,'created_at'=>SORT_DESC);
        return $dataProvider;
    }
}
