<?php

namespace backend\modules\gas_liquid\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\gas_liquid\models\logic\FactoryRegionsLogic;

/**
 * FactoryRegionsSearch represents the model behind the search form of `backend\modules\gas_liquid\models\logic\FactoryRegionsLogic`.
 */
class FactoryRegionsSearch extends FactoryRegionsLogic
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'factory_id', 'created_by', 'created_at', 'deleted_at'], 'integer'],
            [['region'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FactoryRegionsLogic::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'factory_id' => $this->factory_id,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'deleted_at' => 0,
        ]);

        $query->andFilterWhere(['like', 'region', $this->region]);

        return $dataProvider;
    }
}
