<?php

namespace backend\modules\gas_liquid\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\gas_liquid\models\logic\FactoryAgentsLogic;

/**
 * FactoryAgentsSearch represents the model behind the search form of `backend\modules\gas_liquid\models\logic\FactoryAgentsLogic`.
 */
class FactoryAgentsSearch extends FactoryAgentsLogic
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status','number_capsule','factory_id','region_id','agent_id', 'amount', 'confirmed_by', 'confirmation', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FactoryAgentsLogic::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'factory_id' => $this->factory_id,
            'agent_id' => $this->agent_id,
            'region_id' => $this->region_id,
            'status' => $this->confirmation,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
            'deleted_at' => 0,
        ]);

        return $dataProvider;
    }
}
