<?php

namespace backend\modules\gas_liquid\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\gas_liquid\models\activeRecord\AgentUser;

/**
 * AgentUserSearch represents the model behind the search form of `backend\modules\agents\models\activeRecord\AgentUser`.
 */
class AgentUserSearch extends AgentUser
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'agent_id', 'user_id', 'created_by', 'created_at', 'deleted_at'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = AgentUser::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'agent_id' => $this->agent_id,
            'user_id' => $this->user_id,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'deleted_at' => 0,
        ]);

        return $dataProvider;
    }
}
