<?php

namespace backend\modules\gas_liquid\models\search;

use backend\modules\gas_liquid\models\logic\AgentLogic;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\agents\models\activeRecord\Agent;

/**
 * AgentSearch represents the model behind the search form of `backend\modules\agents\models\activeRecord\Agent`.
 */
class AgentSearch extends AgentLogic
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_number','customer_id','id', 'agent_number', 'capacity', 'status', 'sort', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['name', 'tanker_number', 'effective_date', 'safety_date', 'air_conditioning_date','mobile'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = AgentLogic::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'id_number' => $this->id_number,
            'identity_id' => $this->identity_id,
            'customer_id' => $this->customer_id,
            'agent_number' => $this->agent_number,
            'effective_date' => $this->effective_date,
            'safety_date' => $this->safety_date,
            'air_conditioning_date' => $this->air_conditioning_date,
            'capacity' => $this->capacity,
            'status' => $this->status,
            'sort' => $this->sort,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
            'deleted_at' => 0,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'tanker_number', $this->tanker_number]);

        return $dataProvider;
    }
}
