<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryUser;
use backend\modules\gas_liquid\models\activeRecord\FactoryUserQuery;
use backend\modules\user\models\UserLogic;
use backend\modules\user\models\UserQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;
use yii\helpers\ArrayHelper;

class FactoryUserLogic extends FactoryUser
{
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[userId]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUserId()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }



    /**
     * {@inheritdoc}
     * @return FactoryUserQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryUserQuery(get_called_class());
    }

    public static function getAll()
    {
            return static::find()->notDeleted()->all();
    }
    public function get_users_of_factory($factory_id){
        if($records=$this->find()->where(['factory_id'=>$factory_id])->notDeleted()->all()){
            foreach ($records as $index=>$record) {
                $users[$index]['id'] = $record->user_id;
                $users[$index]['name'] = $record->userId->name;
                $users[$index]['user_factory_id'] = $record->id;
            }
            return $users;
        }
        return false;
    }
    public function delete_users_of_factory($factory_id){
        if($records=$this->find()->where(['factory_id'=>$factory_id])->notDeleted()->all()){
            foreach ($records as $record)
                $record->logicalDelete();
        }
        return false;
    }
    public function get_record_of_Specified_factory_Specified_user($factory_id,$user_id){
        if($record=$this->find()->where(['factory_id'=>$factory_id,'user_id'=>$user_id])->notDeleted()->one()){
            return $record;
        }
        return false;
    }
    public function get_user_for_factory()
    {
        $result=array();
        $factory_user=new FactoryUserLogic();
        $user_in_factory=$factory_user->get_user_list();
        $users= $this::find()->where(['not in','id',$user_in_factory])->notDeleted()->all();
        if($users){
            $auth = Yii::$app->authManager;
            foreach ($users as $user) {
                if ($auth->checkAccess($user->id, RoleLogic::PERMISSION_CREATE_OWN_DAILYREPORT))
                    $result[]=$user;
            }
            return $result;
        }
        return $users;
    }
    public function get_user_for_factory_update($factory_id)
    {
        $result=array();
        $factory_user=new FactoryUserLogic();
        $user_in_factory=$factory_user->get_user_list_except_one_specified_factory($factory_id);
        $users= UserLogic::find()->where(['not in','id',$user_in_factory])->notDeleted()->all();
        if($users){
            $auth = Yii::$app->authManager;
            foreach ($users as $user) {
                if (Yii::$app->authManager->getRolesByUser($user->id)=='factory')
                    $result[]=$user;
            }
            return $result;
        }
        return $users;
    }
    public function get_user_list_except_one_specified_factory($factory_id){
        if($user_in_factory= $this::find()->where(['factory_id'=>$factory_id])->notDeleted()->all())
            return ArrayHelper::map($user_in_factory, 'id', 'user_id');
        return array();

    }
    public function get_factory_Of_currentUser(){

        if(Yii::$app->user->id)
            $id=Yii::$app->user->id;
        if($factory_user=$this->find()->where('user_id='.$id)->notDeleted()->one())
            return $factory_user->factory_id;
        return false;
    }
}