<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\models\activeRecord\Customer;
use backend\models\activeRecord\CustomerQuery;
use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\Agent;
use backend\modules\gas_liquid\models\activeRecord\AgentQuery;
use backend\modules\gas_liquid\models\activeRecord\Factory;
use backend\modules\gas_liquid\models\activeRecord\FactoryQuery;
use backend\modules\gas_liquid\models\activeRecord\FactorySales;
use backend\modules\gas_liquid\models\activeRecord\FactorySalesQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;

class FactorySalesLogic extends FactorySales
{
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['factory_id'] = Yii::t('app', 'Factory');
            $labels['agent_id'] = Yii::t('app', 'Agent');
            $labels['customer_id'] = Yii::t('app', 'Customer');
            $labels['tanker_number'] = Yii::t('app', 'Tanker Number');
            $labels['region_id'] = Yii::t('app', 'Region');
            $labels['info_date'] = Yii::t('app', 'Date');
            $labels['amount'] = Yii::t('app', 'Amount');
            $labels['number_capsule'] = Yii::t('app', 'Number Capsule');
            $labels['status'] =Yii::t('app',  'Status');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[factory]].
     *
     * @return \yii\db\ActiveQuery|FactoryQuery
     */
    public function getFactory()
    {
        return $this->hasOne(Factory::className(), ['id' => 'factory_id']);
    }
    /**
     * Gets query for [[agent]].
     *
     * @return \yii\db\ActiveQuery|AgentQuery
     */
    public function getAgent()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }
    /**
     * Gets query for [[customer]].
     *
     * @return \yii\db\ActiveQuery|CustomerQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }


    /**
     * {@inheritdoc}
     * @return FactorySalesQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactorySalesQuery(get_called_class());
    }

    public static function getAll()
    {
            return static::find()->notDeleted()->all();
    }
    public static function getLastRecord($agent=false,$factory=false){
        $where=($agent)?['agent_id'=>$agent]:[];
        $where=($factory)?['factory_id'=>$factory]:$where;
        return FactorySalesLogic::find()->where($where)->orderBy(['created_at'=>SORT_DESC])->notDeleted()->one();
    }
    public static function getBuyOfDate($date=false,$agent=false,$factory=false){
        $where=($agent)?['agent_id'=>$agent]:[];
        $where=($factory)?['factory_id'=>$factory]:$where;
        $where=($date)?['Date(info_date)'=>$date]:$where;
        if($date)
            return self::find()->where($where)->notDeleted()->one();
        else
            return self::find()->where($where)->orderBy(['info_date'=> SORT_DESC])->notDeleted()->one();
    }


}