<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryRegions;
use backend\modules\gas_liquid\models\activeRecord\FactoryRegionsQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;

class FactoryRegionsLogic extends FactoryRegions
{
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[cityId]].
     *
     * @return \yii\db\ActiveQuery|CityQuery
     */
    public function getCityId()
    {
        return $this->hasOne(City::className(), ['id' => 'city_id']);
    }



    /**
     * {@inheritdoc}
     * @return FactoryRegionsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryRegionsQuery(get_called_class());
    }

    public static function getAll($factoryId=false)
    {
        $where=($factoryId)?['factory_id'=>$factoryId]:[];
            return static::find()->where($where)->notDeleted()->all();
    }


}