<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\models\activeRecord\Customer;
use backend\models\activeRecord\CustomerQuery;
use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\Factory;
use backend\modules\gas_liquid\models\activeRecord\FactoryQuery;
use common\components\AuthorBehaviour;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;
use yii\db\ActiveRecord;
use yii\behaviors\TimestampBehavior;
class FactoryLogic extends Factory
{

    const ActiveFactory=1;
    const DisabledFactory=2;
    Const OutdatedFactory=3;
    Const ServicingFactory=4;
    public $users;
    public $description;
    public $manager_name;
    public $manager_mobile;
    public $status;
    public $city_id;
    public $address;
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        $rules[] = [['users'], 'safe'];
        $rules[] =[['description'], 'string'];
        $rules[] =[['status', 'city_id'], 'integer'];
        $rules[] =[['manager_name'], 'string', 'max' => 50];
        $rules[] =[['address'], 'string', 'max' => 200];
        $rules[] =[['manager_mobile'], 'string', 'max' => 20];
        return $rules;
    }

    public function behaviors()

    {
        return [
            AuthorBehaviour::className()

        ];
    }


    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
        $labels['id'] = Yii::t('app', 'ID');
        $labels['name'] = Yii::t('app','Name');
        $labels['address'] = Yii::t('app','Address');
        $labels['customer_id'] = Yii::t('app','Customer');
        $labels['description'] = Yii::t('app','Description');
        $labels['manager_name'] = Yii::t('app','Manager Name');
        $labels['manager_mobile'] = Yii::t('app','Manager Mobile');
        $labels['status'] = Yii::t('app','Status');
        $labels['city_id'] = Yii::t('app','City ID');
        $labels['tanks_number'] = Yii::t('app','Tanks Number');
        $labels['tanks_capacity'] = Yii::t('app','Tanks Capacity');
        $labels['created_by'] = Yii::t('app', 'Created By');
        $labels['created_at'] = Yii::t('app', 'Created At');
        $labels['updated_at'] = Yii::t('app', 'Updated At');
        $labels['updated_by'] = Yii::t('app', 'Updated By');
        $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[customer]].
     *
     * @return \yii\db\ActiveQuery|CustomerQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }



    /**
     * {@inheritdoc}
     * @return FactoryQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryQuery(get_called_class());
    }

    public static function getAll($factoryId=false)
    {
        $where=($factoryId)?['id'=>$factoryId]:[];
       return static::find()->where($where)->notDeleted()->all();

    }
    public static function getStatusList()
    {
        return array(
            Static::ActiveFactory=>Yii::t('app','Active'),
            Static::DisabledFactory=>Yii::t('app','Disabled'),
            Static::OutdatedFactory=>Yii::t('app','Outdated'),
            Static::ServicingFactory=>Yii::t('app','Servicing'),
        );
    }
    public function getStatus()
    {
        $status=$this::getStatusList();
        if(isset($status[$this->status]))
            return $status[$this->status];
        else
            return false;
    }

    public static function getStatusListKey(){
        $counter=1;
        if($records=static::getStatusList()){
            foreach ($records as $index=>$record)
                $status[$index]=$counter++;
            return $status;
        }
        return false;
    }
    public function loadCustomerInfo($customer){
        $this->city_id=$customer->city_id;
        $this->manager_mobile=$customer->manager_mobile;
        $this->manager_name=$customer->manager_name;
        $this->status=$customer->status;
        $this->address=$customer->address;
        $this->name=$customer->name;
    }
    public static function getAgentsOfFactoryWithSaleInfo($factoryId,$date,$agentId=false){
        $agents=($agentId)?AgentLogic::findAll(['id'=>$agentId]):AgentLogic::getAllOfFactory($factoryId);
        foreach ($agents as $agent) {
            $agent=$agent->setBuyFields($date,$factoryId);
        }
        return $agents;
    }

}