<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\models\activeRecord\Identity;
use backend\models\activeRecord\IdentityQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryInvestors;
use backend\modules\gas_liquid\models\activeRecord\FactoryInvestorsQuery;
use backend\modules\user\models\User;
use Yii;

class FactoryInvestorsLogic extends FactoryInvestors
{
    const Active=1;
    const Inactive=0;
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['investor'] = Yii::t('app', 'InvestorName');
            $labels['tanker_number'] = Yii::t('app', 'TankerNumber');
            $labels['tanker_owner'] = Yii::t('app', 'TankerOwner');
            $labels['identity_id'] = Yii::t('app', 'Identity');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }
    /**
     * Gets query for [[identity]].
     *
     * @return \yii\db\ActiveQuery|\backend\models\activeRecord\IdentityQuery
     */
    public function getIdentity()
    {
        return $this->hasOne(Identity::className(), ['id' => 'identity_id']);
    }




    /**
     * {@inheritdoc}
     * @return FactoryInvestorsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryInvestorsQuery(get_called_class());
    }

    public static function getAll($factoryId=false)
    {
        $where=($factoryId)?['factory_id'=>$factoryId]:[];
            return static::find()->where($where)->notDeleted()->all();
    }
    public function statusList()
    {
        return [
            self::Active=>Yii::t('app','Active'),
            self::Inactive=>Yii::t('app','Inactive'),
        ];
    }
    public function getStatus()
    {
        return (isset($this->statusList()[$this->status]))?$this->statusList()[$this->status]:'';
    }

}