<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\Factory;
use backend\modules\gas_liquid\models\activeRecord\FactoryDailyReport;
use backend\modules\gas_liquid\models\activeRecord\FactoryDailyReportQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;

class FactoryDailyReportLogic extends FactoryDailyReport
{
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
            $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['customer_id'] = Yii::t('app', 'Customer');
            $labels['stock'] = Yii::t('app', 'Stock');
            $labels['input'] = Yii::t('app', 'Input');
            $labels['output'] = Yii::t('app', 'Output');
            $labels['info_date'] = Yii::t('app', 'Date');
            $labels['confirmed_by'] = Yii::t('app', 'Confirmed By');
            $labels['confirmation'] = Yii::t('app', 'Confirmation');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }
    /**
     * Gets query for [[factory]].
     *
     * @return \yii\db\ActiveQuery|FactoryQuery
     */
    public function getFactory()
    {
        return $this->hasOne(Factory::className(), ['id' => 'customer_id']);
    }



    /**
     * {@inheritdoc}
     * @return FactoryDailyReportQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryDailyReportQuery(get_called_class());
    }

    public static function getAll()
    {
            return static::find()->notDeleted()->all();
    }

    public function getDataForReport($factories,$date){
        $data=array();
        $sum['stock'] = 0;
        $sum['output'] = 0;
        $sum['input'] = 0;
        $result=false;
        foreach ($factories as $index => $factory) {
            $result[$index]['inputData'] = false;
            $result[$index]['name'] = $factory->name;
            $result[$index]['id'] = $factory->customer_id;
            $result[$index]['factory_id'] = $factory->id;
            $result[$index]['status'] = $factory->status;
            //---------------------------DailyReport-----------------------------------------------
            if ($record = $this->get_report_of_factory($factory->customer_id,  $date)) {
                $result[$index]['reportId'] = $record->id;
                $result[$index]['inputData'] = true;
                //---------------------------stock-----------------------------------------------
                $result[$index]['stock'] = $record->stock;
                if ($record->stock) $sum['stock'] += $record->stock;
                //---------------------------input-----------------------------------------------
                $result[$index]['input'] = $record->input;
                if ($record->input) $sum['input'] += $record->input;
                //---------------------------output-----------------------------------------------
                $result[$index]['output'] = $record->output;
                if ($record->output) $sum['output'] += $record->output;
            }

        }
        $data[0]=$result;
        $data[1]=$sum;
        return $data;
    }
    public function get_report_of_factory($factoryId,$date=false)
    {
        if(!$date)
            $date=date('Y-m-d');
        if($reports=$this->find()->where("customer_id=".$factoryId." AND DATE ( info_date ) ='".$date."'")->notDeleted()->one())
            return $reports;
        return false;

    }
}