<?php


namespace backend\modules\gas_liquid\models\logic;


use backend\modules\country\models\CityQuery;
use backend\modules\gas_liquid\models\activeRecord\AgentQuery;
use backend\modules\gas_liquid\models\activeRecord\Factory;
use backend\modules\gas_liquid\models\activeRecord\FactoryAgents;
use backend\modules\gas_liquid\models\activeRecord\FactoryAgentsQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryQuery;
use backend\modules\gas_liquid\models\activeRecord\FactoryRegions;
use backend\modules\gas_liquid\models\activeRecord\FactoryRegionsQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;
use backend\modules\gas_liquid\models\activeRecord\Agent;
class FactoryAgentsLogic extends FactoryAgents
{
    const Active=1;
    const Inactive=0;
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[factory]].
     *
     * @return \yii\db\ActiveQuery|FactoryQuery
     */
    public function getFactory()
    {
        return $this->hasOne(Factory::className(), ['id' => 'factory_id']);
    }
    /**
     * Gets query for [[agent]].
     *
     * @return \yii\db\ActiveQuery|AgentQuery
     */
    public function getAgent()
    {
        return $this->hasOne(AgentLogic::className(), ['id' => 'agent_id']);
    }
    /**
     * Gets query for [[region]].
     *
     * @return \yii\db\ActiveQuery|FactoryRegionsQuery
     */
    public function getRegion()
    {
        return $this->hasOne(FactoryRegions::className(), ['id' => 'region_id']);
    }



    /**
     * {@inheritdoc}
     * @return FactoryAgentsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryAgentsQuery(get_called_class());
    }

    public static function getAll($agentId=false,$factoryId=false)
    {
        $where=($agentId)?['agent_id'=>$agentId]:[];
        $where=($factoryId)?['factory_id'=>$factoryId]:$where;
        return static::find()->where($where)->notDeleted()->all();

    }
    public static function getOne($id,$agentId=false,$factoryId=false)
    {
        $where=($agentId)?['agent_id'=>$agentId]:[];
        $where=($factoryId)?['factory_id'=>$factoryId]:$where;
        $where=($id)?['id'=>$id]:$where;
        return static::find()->where($where)->andWhere(['status'=>self::Active])->notDeleted()->one();
    }

    public function get_agent($factory_id)
    {
        return $this::find()->where([ 'factory_id' => $factory_id, 'status' => self::Active])->notDeleted()->one();
    }
    public function changeOtherStatus()
    {
        return $this::updateAll(['status'=>self::Inactive],'agent_id='.$this->agent_id.' AND id<>'.$this->id);
    }
    public function statusList()
    {
        return [
          self::Active=>Yii::t('app','Active'),
          self::Inactive=>Yii::t('app','Inactive'),
        ];
    }
    public function getStatus()
    {
        return (isset($this->statusList()[$this->status]))?$this->statusList()[$this->status]:'';
    }
}