<?php


namespace backend\modules\gas_liquid\models\logic;



use backend\modules\gas_liquid\models\activeRecord\Agent;
use backend\modules\gas_liquid\models\activeRecord\AgentQuery;
use backend\modules\gas_liquid\models\activeRecord\AgentUser;
use backend\modules\gas_liquid\models\activeRecord\AgentUserQuery;
use backend\modules\user\models\UserLogic;
use backend\modules\user\models\UserQuery;
use Yii;
use backend\modules\user\models\User;
use yii\base\BaseObject;
use yii\helpers\ArrayHelper;

class AgentUserLogic extends AgentUser
{
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[agentId]].
     *
     * @return \yii\db\ActiveQuery|AgentQuery
     */
    public function getAgentId()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }

    /**
     * Gets query for [[userId]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUserId()
    {
        return $this->hasOne(UserLogic::className(), ['id' => 'user_id']);
    }

    /**
     * {@inheritdoc}
     * @return AgentUserQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AgentUserQuery(get_called_class());
    }

    public static function getAll()
    {
            return static::find()->notDeleted()->all();
    }

    public function get_users_of_agent($agent_id){
        if($records=$this->find()->where(['agent_id'=>$agent_id])->notDeleted()->all()){
            foreach ($records as $index=>$record) {
                $users[$index]['id'] = $record->user_id;
                $users[$index]['name'] = $record->userId->name;
                $users[$index]['user_agent_id'] = $record->id;
            }
            return $users;
        }
        return false;
    }
    public function delete_users_of_agent($agent_id){
        if($records=$this->find()->where(['agent_id'=>$agent_id])->notDeleted()->all()){
            foreach ($records as $record)
                $record->logicalDelete();
        }
        return false;
    }
    public function get_record_of_Specified_agent_Specified_user($agent_id,$user_id){
        if($record=$this->find()->where(['agent_id'=>$agent_id,'user_id'=>$user_id])->notDeleted()->one()){
            return $record;
        }
        return false;
    }
    public function get_user_for_agent()
    {
        $result=array();
        $agent_user=new AgentUserLogic();
        $user_in_agent=$agent_user->get_user_list();
        $users= UserLogic::find()->where(['not in','id',$user_in_agent])->notDeleted()->all();
        if($users){
            $auth = Yii::$app->authManager;
            foreach ($users as $user) {
                if($user->role=='agent')
                    $result[]=$user;
            }
            return $result;
        }
        return $users;
    }
    public function get_user_for_agent_update($agent_id)
    {
        $result=array();
        $agent_user=new AgentUserLogic();
        $user_in_agent=$agent_user->get_user_list_except_one_specified_agent($agent_id);
        $users= UserLogic::find()->where(['not in','id',$user_in_agent])->notDeleted()->all();
        if($users){
            $auth = Yii::$app->authManager;
            foreach ($users as $user) {
                if(in_array("agent",array_keys($auth->getRolesByUser($user->id))))
                    $result[]=$user;
            }
            return $result;
        }
        return $users;
    }
    public function get_user_list_except_one_specified_agent($agent_id){
        if($user_in_agent= $this::find()->where(['agent_id'=>$agent_id])->notDeleted()->all())
            return ArrayHelper::map($user_in_agent, 'id', 'user_id');
        return array();

    }
    public function get_user_list(){
        if($user_in_agent= $this::find()->notDeleted()->all())
            return ArrayHelper::map($user_in_agent, 'id', 'user_id');
        return array();

    }
    public function get_agent_Of_currentUser(){

        if(Yii::$app->user->id)
            $id=Yii::$app->user->id;
        if($agent_user=$this->find()->where('user_id='.$id)->notDeleted()->one())
            return $agent_user->agent_id;
        return false;
    }
}