<?php


namespace backend\modules\gas_liquid\models\logic;



use backend\models\activeRecord\Customer;
use backend\models\activeRecord\CustomerQuery;
use backend\models\activeRecord\Identity;
use backend\models\activeRecord\IdentityQuery;
use backend\models\logic\CustomerLogic;
use backend\modules\gas_liquid\models\activeRecord\Agent;
use backend\modules\gas_liquid\models\activeRecord\AgentQuery;
use backend\modules\user\models\User;
use common\components\ArrayHelper;
use Yii;

class AgentLogic extends Agent
{
    public $users;
    public $address;
    public $mobile;
    public $city_id;
    public  $lastBuy;
    public  $lastBuyDate;
    public  $region;
    public  $factory;
    const TYPE_MOVING=0;
    const TYPE_STATION=1;
    public function rules()
    {
        $rules = parent::rules(); // TODO: Change the autogenerated stub
       // $rules[] =[[ 'name'], SpecificRequiredValidator::class];
        $rules[] =[[ 'users'], 'safe'];
        $rules[] =[['address'], 'string', 'max' => 200];
        $rules[] =[['mobile'], 'string', 'max' => 20];

        return $rules;
    }
    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        $labels = parent::attributeLabels(); // TODO: Change the autogenerated stub
            $labels['id'] = Yii::t('app', 'ID');
            $labels['name'] = Yii::t('app', 'AgentGas Name');
            $labels['id_number'] = Yii::t('app', 'ID Number');
            $labels['type'] = Yii::t('app', 'Type');
            $labels['city_id'] = Yii::t('app', 'City');
            $labels['mobile'] = Yii::t('app', 'Mobile');
            $labels['address'] = Yii::t('app', 'Address');
            $labels['customer_id'] = Yii::t('app', 'Customer');
            $labels['station_id'] = Yii::t('app', 'Station');
            $labels['agent_number'] = Yii::t('app', 'AgentGas Number');
            $labels['tanker_number']= Yii::t('app', 'Tanker Number');
            $labels['effective_date'] = Yii::t('app', 'Effective Date');
            $labels['safety_date'] = Yii::t('app', 'Safety Date');
            $labels['air_conditioning_date'] = Yii::t('app', 'Air Conditioning Date');
            $labels['capacity'] = Yii::t('app', 'Capacity');
            $labels['status'] = Yii::t('app', 'Status');
            $labels['sort'] = Yii::t('app', 'Sort');
            $labels['created_by'] = Yii::t('app', 'Created By');
            $labels['created_at'] = Yii::t('app', 'Created At');
            $labels['updated_at'] = Yii::t('app', 'Updated At');
            $labels['updated_by'] = Yii::t('app', 'Updated By');
            $labels['deleted_at'] = Yii::t('app', 'Deleted At');
            $labels['lastBuy'] = Yii::t('app', 'LastBuy');
            $labels['lastBuyDate'] = Yii::t('app', 'LastBuyDate');
        return $labels;

    }

    /**
     * Gets query for [[CreatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'created_by']);
    }

    /**
     * Gets query for [[UpdatedBy]].
     *
     * @return \yii\db\ActiveQuery|UserQuery
     */
    public function getUpdatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'updated_by']);
    }

    /**
     * Gets query for [[customer]].
     *
     * @return \yii\db\ActiveQuery|CustomerQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }
    /**
     * Gets query for [[station]].
     *
     * @return \yii\db\ActiveQuery|CustomerQuery
     */
    public function getStation()
    {
        return $this->hasOne(Customer::className(), ['id' => 'station_id']);
    }
    /**
     * Gets query for [[identity]].
     *
     * @return \yii\db\ActiveQuery|\backend\models\activeRecord\IdentityQuery
     */
    public function getIdentity()
    {
        return $this->hasOne(Identity::className(), ['id' => 'identity_id']);
    }




    /**
     * {@inheritdoc}
     * @return AgentQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AgentQuery(get_called_class());
    }

    public static function getAll()
    {
            return static::find()->notDeleted()->all();
    }
    public static function getAllOfFactory($factoryId=false)
    {
        $where=($agentList=FactoryAgentsLogic::getAll(false,$factoryId))?['id'=>ArrayHelper::map($agentList,'id','id')]:[];
        return static::find()->where($where)->notDeleted()->all();
    }
    public static function getTypeList(){
        return array(
          self::TYPE_MOVING=>Yii::t('app','جوال'),
          self::TYPE_STATION=>Yii::t('app','ساحة'),
        );
    }
    public static function getStatusList()
    {
        return array(
            CustomerLogic::Active=>Yii::t('app','Active'),
            CustomerLogic::Disabled=>Yii::t('app','Disabled'),
            CustomerLogic::Outdated=>Yii::t('app','Outdated'),
            CustomerLogic::Servicing=>Yii::t('app','Servicing'),
        );
    }
    public function getStatus()
    {
        $status=$this::getStatusList();
        if(isset($status[$this->status]))
            return $status[$this->status];
        else
            return false;
    }
    public function loadCustomerInfo($customer){
        $this->city_id=$customer->city_id;
        $this->mobile=$customer->manager_mobile;
        $this->status=$customer->status;
        $this->address=$customer->address;
        $this->name=$customer->name;
    }
    public function getLastBuy(){
        return FactorySalesLogic::getLastRecord($this->id);
    }
    public static function getOne($id)
    {
        return static::find()->where(['id' => $id])->notDeleted()->one();

    }
    public function setBuyFields($date,$factory_id=false){
        if($buyInfo=FactorySalesLogic::getBuyOfDate($date,$this->id,$factory_id)) {
            $this->lastBuy = $buyInfo->number_capsule;
            $this->lastBuyDate = $buyInfo->info_date;
        }
        return $this;
    }
    public function setRegionField(){
        if($agentRegionFactory=FactoryAgentsLogic::getOne($this->id)) {
            $this->region = $agentRegionFactory->region_id;
            $this->factory = $agentRegionFactory->factory_id;
        }
        return $this;
    }
    public function getCompletedInfo($date=false){
        $this->setBuyFields($date);
        $this->setRegionField($date);
        return $this;
    }
    public static function getCompletedInfoOfAgent($agentId,$date=false){
        $agent=self::getOne($agentId);
        $agent->setBuyFields($date);
        $agent->setRegionField($date);
        return $agent;
    }


}