<?php
/**
 * Created by PhpStorm.
 * User: hamed
 * Date: 11/19/2018
 * Time: 2:03 PM
 */

namespace backend\modules\gas_liquid\models\form;

use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\AgentUserLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use yii\base\Model;

class MessageForm extends Model
{
    public $user;
    public $agent;
    public $message_type;
    public $message;
    public $phone;
    const SendUsernamePassword=1;
    const AlarmForDelay=2;
    const TimeOfSendingDailyReport=3;
    const CustomMessage=4;
    public function rules()
    {
        return [
            [['user','message','phone'], 'required', 'on' => 'create'],
            [['user','agent','message_type'], 'number'],
            [['message'], 'safe'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'user' => Yii::t('app', 'User'),
            'message' => Yii::t('app', 'Message'),
            'agent' => Yii::t('app', 'Agent'),
            'phone' => Yii::t('app', 'Phone'),
            'message_type' => Yii::t('app', 'Message Type'),
        ];
    }
    public function getMessage_type(){
        return array(
          self::SendUsernamePassword=>Yii::t('app','send username and password'),
          self::AlarmForDelay=>Yii::t('app','send delay alarm'),
          self::TimeOfSendingDailyReport=>Yii::t('app','time of sending daily report'),
          self::CustomMessage=>Yii::t('app','custom message'),
        );
    }
    public function getUser($agentId){
        $agentUser=New AgentUserLogic();
        $userList=$agentUser->get_users_of_agent($agentId);
        return $userList;
    }
    public function getMessage(){
        $message='';
        $date=Date('Y/m/d');
        $agentId=$this->agent;
        $user=UserLogic::find()->where(['id'=>$this->user])->notDeleted()->one();
        $agentUserName =($user)?$user->username:'';
        $agentUserPassword = ($user)?$user->password:'';
        if($agent=AgentLogic::getOne($agentId)) {
            $agentName = $agent->name;
            switch ($this->message_type){
            case 1:

                            $message = "السلام علیکم 
عزیزي مدير محطة";
                            $message .= $agentName;
                            $message .= " المحترم ";
                $message .="
يرجى ارسال الموقف اليومي الخاص بكم من الساعة 7:00 مساءا ولغاية الساعة 8:00 صباحا
 عن طريق الرابط ادناه:
Https://bg.opdciq.com

ومعلومات الدخول
اسم المستخدم : ";
                            $message .= $agentUserName;
                            $message .= "
كلمة السر :";
                            $message .= $agentUserPassword;
                            $message .= "
                            
مع تحيات شركة توزيع المنتجات النفطية / هيأة بغداد";
                break;

            case 2:
                $message = "السلام علیکم 
عزیزي مدير محطة";
                $message .= $agentName;
                $message .= " المحترم ";
                $message .="
لم تدخل معلومات الموقف اليومي ليوم ";
                $message .=$date;
                $message .=" عبر النظام الالكتروني";
                $message .="يرجى الاسراع بإدخال الموقف اليومي فورا قبل ساعة ٨";
                $message .="
شركة توزيع المنتجات النفطية / هيأة توزيع بغداد";
                break;

            case 3:
                $message = "السلام علیکم 
عزیزي مدير محطة";
                $message .= $agentName;
                $message .= " المحترم ";
                $message.='
 نشكر اهتمامكم وتعاونكم بإرسال الموقف اليومي عبر النظام الالكتروني 🌹

 نأمل استمراركم بإرسال الموقف اليومي يوميا  قبل الساعة ٨ صباحا وبنفس الالية لتسهيل وتسريع سير ١عمل التوزيع.

شركة توزيع المنتجات النفطية/هيأة توزيع بغداد 
النظام الآلي لتجميع الموقف اليومي';
                break;
            default:
                $message='';
                break;

        }
        }
        return $message;

    }


}