<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_user".
 *
 * @property int $id
 * @property int $factory_id
 * @property int $user_id
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class FactoryUser extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['factory_id', 'user_id', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'factory_id' => 'Factory ID',
            'user_id' => 'User ID',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryUserQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryUserQuery(get_called_class());
    }
}
