<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_sales".
 *
 * @property int $id
 * @property int|null $factory_id
 * @property int|null $agent_id
 * @property int|null $customer_id
 * @property string|null $tanker_number
 * @property int|null $region_id
 * @property string|null $info_date
 * @property string|null $amount
 * @property int|null $number_capsule
 * @property int|null $status
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class FactorySales extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_sales';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['factory_id'],'required'],
            [['factory_id', 'agent_id', 'customer_id', 'region_id', 'number_capsule', 'status', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['info_date'], 'safe'],
            [['tanker_number', 'amount'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'factory_id' => 'Factory ID',
            'agent_id' => 'Agent ID',
            'customer_id' => 'Customer ID',
            'tanker_number' => 'Tanker Number',
            'region_id' => 'Region ID',
            'info_date' => 'Info Date',
            'amount' => 'Amount',
            'number_capsule' => 'Number Capsule',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactorySalesQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactorySalesQuery(get_called_class());
    }
}
