<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_regions".
 *
 * @property int $id
 * @property int $factory_id
 * @property string $region
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class FactoryRegions extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_regions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['factory_id', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['region'], 'required'],
            [['region'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'factory_id' => 'Factory ID',
            'region' => 'Region',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryRegionsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryRegionsQuery(get_called_class());
    }
}
