<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_investors".
 *
 * @property int $id
 * @property int $factory_id
 * @property string|null $investor
 * @property int|null $identity_id
 * @property string|null $tanker_number
 * @property string|null $tanker_owner
 * @property int|null $status
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class FactoryInvestors extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_investors';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['factory_id'], 'required'],
            [['factory_id', 'identity_id', 'status', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['investor', 'tanker_owner'], 'string', 'max' => 50],
            [['tanker_number'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'factory_id' => 'Factory ID',
            'investor' => 'Investor',
            'identity_id' => 'Identity ID',
            'tanker_number' => 'Tanker Number',
            'tanker_owner' => 'Tanker Owner',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryInvestorsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryInvestorsQuery(get_called_class());
    }
}
