<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_daily_report".
 *
 * @property int $id
 * @property int $customer_id
 * @property float $stock
 * @property float $input
 * @property float $output
 * @property string|null $info_date
 * @property int|null $confirmed_by
 * @property int|null $confirmation
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int|null $deleted_at
 */
class FactoryDailyReport extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_daily_report';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_id'], 'required'],
            [['customer_id', 'confirmed_by', 'confirmation', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['stock', 'input', 'output'], 'number'],
            [['info_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_id' => 'Factory ID',
            'stock' => 'Stock',
            'input' => 'Input',
            'output' => 'Output',
            'info_date' => 'Info Date',
            'confirmed_by' => 'Confirmed By',
            'confirmation' => 'Confirmation',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryDailyReportQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryDailyReportQuery(get_called_class());
    }
}
