<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory_agents".
 *
 * @property int $id
 * @property int|null $factory_id
 * @property int|null $region_id
 * @property int|null $agent_id
 * @property int|null $status
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int|null $deleted_at
 */
class FactoryAgents extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory_agents';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['agent_id'], 'required'],
            [['status','factory_id','region_id','agent_id', 'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['info_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'factory_id' => 'Factory',
            'agent_id' => 'Agent',
            'region_id' => 'Region',
            'ststus' => 'Status',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryAgentsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryAgentsQuery(get_called_class());
    }
}
