<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "factory".
 *
 * @property int $id
 * @property string $name
 * @property int $customer_id
 * @property int|null $tanks_capacity
 * @property int|null $tanks_number
 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class Factory extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factory';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [[ 'tanks_number','tanks_capacity','customer_id','created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['name'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'tanks_number' => 'Tanks Number',
            'tanks_capacity' => 'Tanks Capacity',
            'customer_id' => 'Customer ID',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return FactoryQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new FactoryQuery(get_called_class());
    }
}
