<?php

namespace backend\modules\gas_liquid\models\activeRecord;

use Yii;

/**
 * This is the model class for table "agent".
 *
 * @property int $id
 * @property string $name
 * @property int $type
 * @property int|null $id_number
 * @property int|null $customer_id
 * @property int|null $station_id
 * @property int|null $identity_id
 * @property int|null $agent_number
 * @property string|null $tanker_number
 * @property string|null $effective_date
 * @property string|null $safety_date
 * @property string|null $air_conditioning_date
 * @property int|null $capacity
 * @property int|null $status

 * @property int $created_by
 * @property int $created_at
 * @property int $updated_at
 * @property int $updated_by
 * @property int $deleted_at
 */
class Agent extends \common\models\BaseActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'agent';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['station_id','identity_id','id_number','customer_id','type','agent_number', 'capacity', 'status', 'sort',  'created_by', 'created_at', 'updated_at', 'updated_by', 'deleted_at'], 'integer'],
            [['effective_date', 'safety_date', 'air_conditioning_date'], 'safe'],
            [['name'], 'string', 'max' => 500],
            [['tanker_number'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Type',
            'name' => 'Name',
            'identity_id' => 'ID Number',
            'id_number' => 'ID Number',
            'customer_id' => 'Customer ID',
            'station_id' => 'Station ID',
            'agent_number' => 'Agent Number',
            'tanker_number' => 'Tanker Number',
            'effective_date' => 'Effective Date',
            'safety_date' => 'Safety Date',
            'air_conditioning_date' => 'Air Conditioning Date',
            'capacity' => 'Capacity',
            'status' => 'Status',
            'sort' => 'Sort',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'deleted_at' => 'Deleted At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AgentQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AgentQuery(get_called_class());
    }
}
