<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use backend\modules\gas_liquid\models\logic\FactoryUserLogic;
use backend\modules\gas_liquid\models\search\FactoryUserSearch;
use common\controllers\BaseController;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * FactoryUserController implements the CRUD actions for FactoryUserLogic model.
 */
class FactoryUserController extends BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['delete-user-ajax','create-user-ajax'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all FactoryUserLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FactoryUserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FactoryUserLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryUserLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryUserLogic();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryUserLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactoryUserLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactoryUserLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryUserLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryUserLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionCreateUserAjax()
    {
        $model = new UserLogic();
        $model->setScenario('create');
        $result['msg']= Yii::t('app', 'Error occurred during user creating');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if (isset($post['factoryId']) && $post['factoryId']){
            $factoryId=$post['factoryId'];
        }
        foreach ($post['data'] as $index=>$content){
             $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
             $data['UserLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if ($model->load($data)) {
                $model->setPassword($model->password);
                $model->generatePasswordResetToken();
                $model->generateAuthKey();

                if ($model->email == '') $model->email = null;
                if ($model->save()) {
                    $auth = Yii::$app->authManager;
                    $authRole = $auth->getRole($model->role);
                    $auth->assign($authRole, $model->id);
                    //-------------------------Create Factory User-------------------------------------------------
                    $modelFactoryUser=New FactoryUserLogic();
                    $modelFactoryUser->user_id=$model->id;
                    $modelFactoryUser->factory_id=$factoryId;
                    if($modelFactoryUser->save()) {
                        $result['result']=1;
                        $result['msg'] = Yii::t('app', 'User has been successfully submitted');
                        $result['data']='<div class="row  parent_of_dropdown">
                                                <div class="col-6 pl-0">
                                                    <span class="form-control users_list">'.$modelFactoryUser->userId->name.'</span>
                                                </div>
                                                <div class="col-2 parent_of_btn "><span id="'.$modelFactoryUser->id.'" title="حذف" class="btn-create2   delete-user addContent"><i class="fa fa-minus"></i></span>
                                                </div>
                                            </div>';
                    }
                }
            }
        }
        return json_encode($result);

    }
    public function actionDeleteUserAjax()
    {

        $result['msg']= Yii::t('app', 'Error occurred during user deleting!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['userFactoryId']) && $post['userFactoryId']) $id=$post['userFactoryId'];
        if($id && ($model = $this->findModel($id))) {
            if ($model->logicalDelete()) {
                $result['msg'] =  Yii::t('app', 'User has been successfully deleted!');
                $result['result']=1;
            }

        }
        return json_encode($result);

    }
}
