<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\user\models\RoleLogic;
use Yii;
use backend\modules\gas_liquid\models\logic\FactorySalesLogic;
use backend\modules\gas_liquid\models\search\FactorySalesSearch;
use common\controllers\BaseController;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * FactorySalesController implements the CRUD actions for FactorySalesLogic model.
 */
class FactorySalesController extends BaseController
{
    public $layout='gasLiquid';

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['create-sale-ajax','fetch-sale-ajax','index','create'],
                        'roles' => [RoleLogic::PERMISSION_SALE_FACTORY],
                    ],

                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FactorySalesLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $date = date('Y-m-d');
        $searchModel = new FactorySalesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $modelNewSale=New FactorySalesLogic();
        return $this->render('index', [
            'date'=>$date,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'modelNewSale'=>$modelNewSale,
        ]);
    }

    /**
     * Displays a single FactorySalesLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactorySalesLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactorySalesLogic();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactorySalesLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactorySalesLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactorySalesLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactorySalesLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactorySalesLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionFetchSaleAjax()
    {

        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['date']) && $post['date']) $date=$post['date'];
        if(isset($post['factory']) && $post['factory']) $factory=$post['factory'];
        if($date && $factory) {
            $title=Yii::t('app', 'Create') . ' ' . Yii::t('app', 'Sale');
            if ($model=FactorySalesLogic::find()->where(['factory_id'=>$factory,'Date(info_date)'=>$date])->notDeleted()->one()) {
                $title=Yii::t('app', 'Update') . ' ' . Yii::t('app', 'Sale');
                $result['result']=1;
                $result['data']['id']=$model->id;
                $result['data']['amount']=$model->amount;
            }
            $result['data']['title']=(($factoryModel=FactoryLogic::find()->where(['id'=>$factory])->notDeleted()->one())?$title.' '.$factoryModel->name:$title);
        }
        return json_encode($result);

    }
    public function actionCreateSaleAjax()
    {
        $model = new FactorySalesLogic();
        $result['msg']= Yii::t('app', 'Error occurred during registering factory sale!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        foreach ($post['data'] as $index=>$content){
            $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
            $data['FactorySalesLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if( $data['FactorySalesLogic']['id']  &&  FactorySalesLogic::getOne($data['FactorySalesLogic']['id']))
                $model=FactorySalesLogic::getOne($data['FactorySalesLogic']['id']);
            if ($model->load($data)) {
                if ($model->save()) {
                    $result['result'] = 1;
                    $result['msg'] = Yii::t('app', 'Factory sale has been successfully submitted');
                    $result['data']['sale'] =
                        '<a  class="btn-show-sale" title="انشاء الطلبية">'.Digits::Show_long_numbers($model->amount).'</a>';
                    $result['data']['factory'] = $model->factory_id;
                }
            }
        }
        return json_encode($result);

    }
}
