<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\user\models\RoleLogic;
use Yii;
use backend\modules\gas_liquid\models\logic\FactoryRegionsLogic;
use backend\modules\gas_liquid\models\search\FactoryRegionsSearch;
use common\controllers\BaseController;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Url;
/**
 * FactoryRegionsController implements the CRUD actions for FactoryRegionsLogic model.
 */
class FactoryRegionsController extends BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['delete-region-ajax','create-region-ajax','get-region-ajax'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FactoryRegionsLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FactoryRegionsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FactoryRegionsLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryRegionsLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryRegionsLogic();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['factory/update', 'id' => $model->factory_id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryRegionsLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactoryRegionsLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactoryRegionsLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryRegionsLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryRegionsLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionCreateRegionAjax()
    {

        $result['message']= Yii::t('app', 'Error occurred during region creating');
        $result['result']=0;
        $post=Yii::$app->request->post();
        $factory=null;
        if(isset($post['region']) && $post['region']) $region=$post['region'];
        if(isset($post['factory']) && $post['factory']) $factory=$post['factory'];
        if($region ) {
            $model = new FactoryRegionsLogic();
            $model->region=$region;
            $model->factory_id=$factory;
            if ($model->save()) {
                $result['message'] =  Yii::t('app', 'Region has been successfully submitted');
                $result['result']=1;
                $result['data']='<option value="'.$model->id.'" selected="selected">'.$model->region.'</option>';
            }

        }
        return json_encode($result);

    }
    public function actionDeleteRegionAjax()
    {

        $result['message']= Yii::t('app', 'Error occurred during region deleting!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['id']) && $post['id']) $id=$post['id'];
        if($id && ($model = $this->findModel($id))) {
            if ($model->logicalDelete()) {
                $result['message'] =  Yii::t('app', 'Region has been successfully deleted!');
                $result['result']=1;
            }

        }
        return json_encode($result);

    }
    public function actionGetRegionAjax()
    {
        $post=Yii::$app->request->post();
        $html='';
        if(isset($post['factoryId']) && $post['factoryId']) $id=$post['factoryId'];
        if($id) {
            if ($regionList=FactoryRegionsLogic::getAll($id)) {
                $html='<option></option>';
                foreach ($regionList as $regionFactory)
                    $html.='<option value="'.$regionFactory->id.'">'.$regionFactory->region.'</option>';
            }
        }
        $result['data']=$html;
        return json_encode($result);

    }
}
