<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use backend\modules\gas_liquid\models\logic\FactoryUserLogic;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use backend\modules\gas_liquid\models\activeRecord\Factory;
use backend\modules\gas_liquid\models\search\FactorySearch;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * FactoryPanelController implements the CRUD actions for Factory model.
 */
class FactoryPanelController extends \common\controllers\BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index'],
                        'roles' => [RoleLogic::PERMISSION_OWN_PANEl_FACTORY,RoleLogic::PERMISSION_CREATE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all Factory models.
     * @return mixed
     */
    public function actionIndex($id=false)
    {
        if (Yii::$app->user->identity->role=='admin')
            $factory_id=$id;
        $factory=New FactoryLogic();
        $model_factory_user=New FactoryUserLogic();
        $date=Date('Y-m-d');
        //----------------------------check Factory-----------------------------------
       if ((!isset($factory_id)) && (!$factory_id = $model_factory_user->get_factory_Of_currentUser()))
            Yii::$app->getSession()->setFlash('fatal', Yii::t('app', 'You do not have any active factory'));
       else {
           if ($post = Yii::$app->request->post())
               list($date,$agentSearched)=$this->getDataFromPostFilterForm($post);
           $factory=$this->findModel($factory_id);
           $agents=FactoryLogic::getAgentsOfFactoryWithSaleInfo($factory_id,$date);

       }
       $agentList=ArrayHelper::map(AgentLogic::getAllOfFactory($factory_id),'id','name');
       return $this->render('index', [
           'factory' => $factory,
           'agents'=>$agents,
           'date'=>$date,
           'agentSearched'=>(isset($agentSearched)?$agentSearched:false),
           'agentList'=>$agentList
       ]);
    }


    /**
     * Finds the Factory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Factory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    protected function getDataFromPostFilterForm($post){
        $date =(isset($post['date']) && $post['date']) ?date('Y-m-d',strtotime($post['date'])):false;
        $agent =(isset($post['agent']) && $post['agent']) ?AgentLogic::getCompletedInfoOfAgent($post['agent']):false;
        return array($date,$agent);
    }

}
