<?php

namespace backend\modules\gas_liquid\controllers;
use backend\models\logic\IdentityLogic;
use backend\modules\gas_liquid\models\activeRecord\FactoryInvestors;
use backend\modules\gas_liquid\models\logic\FactoryInvestorsLogic;
use backend\modules\gas_liquid\models\search\FactoryInvestorsSearch;
use backend\modules\user\models\RoleLogic;
use Yii;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;

/**
 * FactoryInvestorsController implements the CRUD actions for FactoryInvestors model.
 */
class FactoryInvestorsController extends \common\controllers\BaseController
{
    public $layout='gasLiquid';

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['delete','fetch-investor-ajax','fetch-identity-ajax'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                ],
            ],

        ];
    }

    /**
     * Lists all FactoryInvestors models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FactoryInvestorsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FactoryInvestors model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryInvestors model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryInvestors();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryInvestors model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactoryInvestors model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        if($model=$this->findModel($id)) {
            $factory_id=$model->factory_id;
            if(!$model->identity_id || ($this->findIdentityModel($model->identity_id)->logicalDelete()))
                    if($model->logicalDelete()) {
                        Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Investor successfully deleted'));
                        return $this->redirect(['factory/update','id'=>$factory_id]);
                    }

        }

        Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while deleting the agent. Please try again.'));
        return $this->redirect(['factory/update','id'=>$factory_id]);
    }

    /**
     * Finds the FactoryInvestors model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryInvestors the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryInvestorsLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    /**
     * Finds the Identity model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return IdentityLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findIdentityModel($id)
    {
        if (($model = IdentityLogic::findOne($id)) !== null) {
            return $model;
        }

    }
    public function actionFetchIdentityAjax()
    {

        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['id']) && $post['id']) $id=$post['id'];
        if($id && ($model=$this->findModel($id))) {
            $result['result']=1;
            $title=Yii::t('app', 'Update') . ' ' . $model->investor;
            //$result['investor']=$model->getAttributes();
            $result['title']=$title;
            $result['id']='<input type="hidden" id="factoryinvestorslogic-id" class="form-control" name="FactoryInvestorId" value="'.$id.'" >';
            if ($model->identity_id && $identity=$this->findIdentityModel($model->identity_id)) {
                $result['identity']=$identity->getAttributes();
            }
      }
        return json_encode($result);
    }
    public function actionFetchInvestorAjax()
    {

        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['id']) && $post['id']) $id=$post['id'];
        if($id && ($model=$this->findModel($id))) {
            $result['result']=1;
            $result['id']='<input type="hidden" id="factoryinvestorslogic-id" class="form-control" name="FactoryInvestorId" value="'.$id.'" >';
            $title=Yii::t('app', 'Update') . ' ' . $model->investor;
            $result['investor']=$model->getAttributes();
            $result['title']=$title;
        }
        return json_encode($result);
    }


}
