<?php

namespace backend\modules\gas_liquid\controllers;

use backend\models\logic\CustomerLogic;
use backend\models\logic\DailyreportLogic;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use backend\models\logic\ProductLogic;
use backend\modules\user\models\RoleLogic;
use common\components\MyPdf;
use Yii;
use backend\modules\gas_liquid\models\logic\FactoryDailyReportLogic;
use backend\modules\gas_liquid\models\search\FactoryDailyReportSearch;
use common\controllers\BaseController;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\Digits;

/**
 * FactoryDailyReportController implements the CRUD actions for FactoryDailyReportLogic model.
 */
class FactoryDailyReportController extends BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index','export'],
                        'roles' => [RoleLogic::PERMISSION_LIST_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['create-daily-report-ajax','fetch-daily-report-ajax'],
                        'roles' => [RoleLogic::PERMISSION_REPORT_FACTORY],
                    ],

                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all FactoryDailyReportLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new FactoryDailyReportLogic();
        $factories = FactoryLogic::getAll();
        $factory_id = null;
        $entry_data = false;
        $date = date('Y-m-d');
        $entry_data_selection=['1' , '2' ];
        if (Yii::$app->request->post()) {
            $post = Yii::$app->request->post();
            if (isset($post['info_date'])) $date = $post['info_date'];
            if (isset($post['factory_id']) && $post['factory_id']) {
                $factory_id = $post['factory_id'];
                $factories = FactoryLogic::getAll($factory_id);
            }
            if (isset($post['entry_data'])) {
                $tmpEntryData=$post['entry_data'];
                if(count($tmpEntryData)==2)
                    $entry_data=false;
                else
                    $entry_data = $tmpEntryData[0];
                $entry_data_selection=$tmpEntryData;
            }

        }
        $product_titles = 'Liquid_gas';
        $product=($productModel = ProductLogic::getProductRecordByProductTitle($product_titles))?$productModel->name:'';
        $modelNewDailyReport=New FactoryDailyReportLogic();
        $data=$model->getDataForReport($factories,$date);
        $result=$data[0];
        $sum=$data[1];
        return $this->render('index', [
            'factory' => $factory_id,
            'factories' => $factories,
            'lists' => $result,
            'date' => $date,
            'sum' => $sum,
            'entry_data' => $entry_data,
            'product'=>$product,
            'entry_data_selection'=>$entry_data_selection,
            'modelNewDailyReport'=>$modelNewDailyReport,
        ]);
    }

    public function actionExport()
    {
        $model = new FactoryDailyReportLogic();
        $factories = FactoryLogic::getAll();
        $factory_id = null;
        $entry_data = false;
        $date = date('Y-m-d');
        if (Yii::$app->request->get()) {
            $get = Yii::$app->request->post();
            if (isset($get['info_date'])) $date = $get['info_date'];

        }
        $product_titles = 'Liquid_gas';
        $product=($productModel = ProductLogic::getProductRecordByProductTitle($product_titles))?$productModel->name:'';
        $data=$model->getDataForReport($factories,$date);
        $lists=$data[0];
        $sum=$data[1];
        $pdf=new MyPdf();
        $pdf->content=$this->renderPartial('export', [
            'factory' => $factory_id,
            'lists' => $lists,
            'date' => $date,
            'sum' => $sum,
            'entry_data' => $entry_data,
            'product'=>$product,
        ]);
        return $pdf->render();
    }

    /**
     * Displays a single FactoryDailyReportLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryDailyReportLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryDailyReportLogic();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryDailyReportLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactoryDailyReportLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactoryDailyReportLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryDailyReportLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryDailyReportLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionFetchDailyReportAjax()
    {

        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['date']) && $post['date']) $date=$post['date'];
        if(isset($post['customer']) && $post['customer']) $customer=$post['customer'];
        if($date && $customer) {
            $title=Yii::t('app', 'Create') . ' ' . Yii::t('app', 'Dailyreport');
            $result['data']['title']=(($customerModel=CustomerLogic::find()->where(['id'=>$customer])->notDeleted()->one())?$title.' '.$customerModel->name:$title);
            $result['data']['customer_id']=$customer;
            if ($model=FactoryDailyReportLogic::find()->where(['customer_id'=>$customer,'Date(info_date)'=>$date])->notDeleted()->one()) {
                $result['result']=1;
                $result['data']['id']=$model->id;
                $result['data']['stock']=$model->stock;
                $result['data']['stock']=$model->stock;
                $result['data']['input']=$model->input;
                $result['data']['output']=$model->output;

            }
        }
        return json_encode($result);

    }
    public function actionCreateDailyReportAjax()
    {
        $model = new FactoryDailyReportLogic();
        $result['msg']= Yii::t('app', 'Error occurred during registering factory daily report!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        foreach ($post['data'] as $index=>$content){
            $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
            $data['FactoryDailyReportLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if( $data['FactoryDailyReportLogic']['id']  &&  $this->findModel($data['FactoryDailyReportLogic']['id']))
                $model = FactoryDailyReportLogic::findOne($data['FactoryDailyReportLogic']['id']);
            if ($model->load($data)) {
                if ($model->save()) {
                    $result['result'] = 1;
                    $result['data']['customer_id'] = $model->customer_id;
                    $result['msg'] = Yii::t('app', 'Factory daily report has been successfully submitted');
                    $result['data']['stock'] =
                    '<a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي">'.Digits::Show_long_numbers($model->stock).'</a>';
                    $result['data']['input'] =
                    '<a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي">'.Digits::Show_long_numbers($model->input).'</a>';
                    $result['data']['output'] =
                    '<a  class="btn-show-daily-report" title="انشاء موقف تجهيز يومي">'.Digits::Show_long_numbers($model->output).'</a>';
                }
            }
        }
        return json_encode($result);

    }

}
