<?php

namespace backend\modules\gas_liquid\controllers;

use backend\models\logic\CustomerLogic;
use backend\models\logic\IdentityLogic;
use backend\modules\contract\models\logic\CustomerAttributesLogic;
use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\FactoryAgentsLogic;
use backend\modules\gas_liquid\models\logic\FactoryInvestorsLogic;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use backend\modules\gas_liquid\models\logic\FactoryRegionsLogic;
use backend\modules\gas_liquid\models\logic\FactoryUserLogic;
use backend\modules\gas_liquid\models\search\FactorySearch;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use common\controllers\BaseController;
use Yii;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * FactoryController implements the CRUD actions for FactoryLogic model.
 */
class FactoryController extends BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index'],
                        'roles' => [RoleLogic::PERMISSION_LIST_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['create','insert_user_block'],
                        'roles' => [RoleLogic::PERMISSION_CREATE_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['update'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['delete'],
                        'roles' => [RoleLogic::PERMISSION_DELETE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all FactoryLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FactorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FactoryLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryLogic();
        $modelCustomer=New CustomerLogic();
        $model->status=$model::ActiveFactory;
        $customerType=CustomerLogic::LiquidGasFactory;
        if ($post=Yii::$app->request->post() ) {
            $model->load($post);
            $customer['CustomerLogic']=$post['FactoryLogic'];
            $modelCustomer->load($customer);
            $modelCustomer->city_id = ($model->city_id) ? $model->city_id : Yii::$app->params['city_id'];
            $modelCustomer->status = ($model->status) ? $model->status : CustomerLogic::Active;
            $modelCustomer->type=$customerType;
            if ($modelCustomer->save()) {
                $model->customer_id = $modelCustomer->id;
                if ($model->save()) {
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Factory successfully registered'));
                    return $this->redirect(['update', 'id' => $model->id]);
                } else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the factory. Please try again.'));
            }else
                Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the factory. Please try again.'));

        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $user_array=array();
        $model_factory_user=new FactoryUserLogic();
        $result=false;
        if($users=$model_factory_user->get_users_of_factory($model->id))
            $user_array = ArrayHelper::map($users, 'id', 'id');
        $modelCustomer = $this->findModelCustomer($model->customer_id);
        $model->loadCustomerInfo($modelCustomer);
        $modeFactoryAgentNew=New FactoryAgentsLogic();
        $modelFactoryInvestorNew=New FactoryInvestorsLogic();
        $modeIdentity=New IdentityLogic();

        $contractsList=CustomerAttributesLogic::getAll($model->customer_id);

        if ($post=Yii::$app->request->post()) {
            if (isset($post['FactoryAgentsLogic'])) {
                $modeFactoryAgentNew->load($post);
                $modeFactoryAgentNew->status=FactoryAgentsLogic::Active;
                if ($modeFactoryAgentNew->save()){
                    $modeFactoryAgentNew->changeOtherStatus();
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully registered'));
                }
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));
            }
            if (isset($post['IdentityLogic'])) {
                if(isset($post['FactoryInvestorId']))  {
                    $modeInvestor=$this->findInvestorModel($post['FactoryInvestorId']);
                    if($modeInvestor->identity_id) $modeIdentity=$this->findIdentityModel($modeInvestor->identity_id);
                    $modeIdentity->load($post);
                    if ($modeIdentity->save()) {
                        $modeInvestor->identity_id=$modeIdentity->id;
                        $result = $modeInvestor->save();
                        Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Identity successfully registered'));
                    }
                    else
                        Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the identity. Please try again.'));

                }
          }
            if (isset($post['FactoryInvestorsLogic'])) {
                if(isset($post['FactoryInvestorId']))
                    $modelFactoryInvestorNew=$this->findInvestorModel($post['FactoryInvestorId']);
                $modelFactoryInvestorNew->load($post);
                $modelFactoryInvestorNew->status=FactoryInvestorsLogic::Active;
                if ($modelFactoryInvestorNew->save()){
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Investor successfully registered'));
                }
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the investor. Please try again.'));
            }
            if (isset($post['FactoryLogic'])) {
                if ($model->load($post)) {
                    $customer['CustomerLogic'] = Yii::$app->request->post()['FactoryLogic'];
                    $modelCustomer->load($customer);
                    if (($result = $modelCustomer->save()) && ($result = $model->save())) {
                        if ($model->users) {
                            foreach ($model->users as $user) {
                                if ($user && (!in_array($user, $user_array))) {
                                    $model_user = new FactoryUserLogic();
                                    $model_user->factory_id = $model->id;
                                    $model_user->user_id = $user;
                                    if (!$model_user->save()) $result = false;
                                }
                            }
                        }
                    }
                 }
                if ($result)
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Factory successfully registered'));
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the factory. Please try again.'));

            }

    }
        $factoryAgentList=FactoryAgentsLogic::getAll(false,$id);
        $factoryRegionsList=FactoryRegionsLogic::getAll($id);
        $factoryInvestors=FactoryInvestorsLogic::getAll($id);
        $modelFactoryRegionsNew=New FactoryRegionsLogic();
        $modelUserNew=New UserLogic();
        $modelNewAgent=New AgentLogic();
        $modelInvestor=New FactoryInvestorsLogic();
        return $this->render('update', [
            'model' => $model,
            'users'=>$users,
            'modelFactoryRegionsNew'=>$modelFactoryRegionsNew,
            'modelUserNew'=>$modelUserNew,
            'modelNewAgent'=>$modelNewAgent,
            'factoryRegionsList'=>$factoryRegionsList,
            'factoryAgentList'=>$factoryAgentList,
            'modeFactoryAgentNew'=>$modeFactoryAgentNew,
            'modelFactoryInvestorNew'=>$modelFactoryInvestorNew,
            'factoryInvestors'=>$factoryInvestors,
            'modeIdentity'=>$modeIdentity,
            'modelInvestor'=>$modelInvestor,
            'contractsList'=>$contractsList,
        ]);
    }

    /**
     * Deletes an existing FactoryLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        if($this->findModel($id)->logicalDelete())
            Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Factory successfully deleted'));
        else
            Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while deleting the factory. Please try again.'));

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactoryLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    /**
     * Finds the Identity model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return \backend\models\logic\IdentityLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findIdentityModel($id)
    {
        if (($model = IdentityLogic::findOne($id)) !== null) {
            return $model;
        }

    }
    /**
     * Finds the Investor model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryInvestorsLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findInvestorModel($id)
    {
        if (($model = FactoryInvestorsLogic::findOne($id)) !== null) {
            return $model;
        }

    }
    public function actionInsert_user_block(){
        $data=Yii::$app->request->get();
        if(isset($data)){
            if(isset($data['id']))
                $id = (int)$data['id'];
            else
                return 0;
            if(isset($data['factory']))
                $factory = (int)$data['factory'];
            else
                $factory=0;
        }
        $id++;
        $models_user=new FactoryUserLogic();
        $html='<div class="row parent_of_dropdown"><div class="col-6"><div class="form-group field-factorylogic-user_id has-success">';
        $html.='<select id="'.$id.'" class="form-control users_list" name="FactoryLogic[users]['.$id.']" aria-invalid="false">';
        $html.='<option></option>';
        if($factory){
            $model_user_for_factory=$models_user->get_user_for_factory_update($factory);
        }else{
            $model_user_for_factory=$models_user->get_user_for_factory();
        }
        if($model_user_for_factory) {
            foreach ($model_user_for_factory as $model_user) {
                $html.="<option value='$model_user->id'>$model_user->name</option>";
            }
        }
        $html.='</select>';
        $html.='<div class="help-block"></div>';
        $html.='</div></div>';
        $html.='<div class="col-2 parent_of_btn"><span class="btn-create2 removeContent" ><i class="fa fa-minus"></i></span></div></div>';
        return $html;
    }
    /**
     * Finds the Customer model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return CustomerLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModelCustomer($id)
    {
        if (($model = CustomerLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
