<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\user\models\RoleLogic;
use Yii;
use backend\modules\gas_liquid\models\logic\FactoryAgentsLogic;
use backend\modules\gas_liquid\models\search\FactoryAgentsSearch;
use common\controllers\BaseController;
use yii\filters\AccessControl;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\modules\gas_liquid\models\logic\FactoryLogic;
use common\components\Digits;

/**
 * FactoryAgentsController implements the CRUD actions for FactoryAgentsLogic model.
 */
class FactoryAgentsController extends BaseController
{
    public $layout='gasLiquid';

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['create-agent-ajax','fetch-agent-ajax'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],

                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all FactoryAgentsLogic models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FactoryAgentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single FactoryAgentsLogic model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FactoryAgentsLogic model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FactoryAgentsLogic();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing FactoryAgentsLogic model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing FactoryAgentsLogic model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the FactoryAgentsLogic model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FactoryAgentsLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FactoryAgentsLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionFetchAgentAjax()
    {

        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['date']) && $post['date']) $date=$post['date'];
        if(isset($post['factory']) && $post['factory']) $factory=$post['factory'];
        if($date && $factory) {
            $title=Yii::t('app', 'Create') . ' ' . Yii::t('app', 'Agent');
            if ($model=FactoryAgentsLogic::find()->where(['factory_id'=>$factory,'Date(info_date)'=>$date])->notDeleted()->one()) {
                $title=Yii::t('app', 'Update') . ' ' . Yii::t('app', 'Agent');
                $result['result']=1;
                $result['data']['id']=$model->id;
                $result['data']['amount']=$model->amount;
            }
            $result['data']['title']=(($factoryModel=FactoryLogic::find()->where(['id'=>$factory])->notDeleted()->one())?$title.' '.$factoryModel->name:$title);
        }
        return json_encode($result);

    }
    public function actionCreateAgentAjax()
    {
        $model = new FactoryAgentsLogic();
        $result['msg']= Yii::t('app', 'Error occurred during registering factory agent!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        foreach ($post['data'] as $index=>$content){
            $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
            $data['FactoryAgentsLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if( $data['FactoryAgentsLogic']['id']  &&  FactoryAgentsLogic::getOne($data['FactoryAgentsLogic']['id']))
                $model=FactoryAgentsLogic::getOne($data['FactoryAgentsLogic']['id']);
            if ($model->load($data)) {
                if ($model->save()) {
                    $result['result'] = 1;
                    $result['msg'] = Yii::t('app', 'Factory agent has been successfully submitted');
                    $result['data']['agent'] =
                        '<a  class="btn-show-agent" title="انشاء الطلبية">'.Digits::Show_long_numbers($model->amount).'</a>';
                    $result['data']['factory'] = $model->factory_id;
                }
            }
        }
        return json_encode($result);

    }
}
